/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.feign.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.rulecode.sdk.constant.GenerateCodeRuleConstant;
import com.biz.crm.common.rulecode.sdk.enums.RuleCodeRedisEnum;
import com.biz.crm.common.rulecode.sdk.service.GenerateCodeRuleVoService;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"GenerateCodeRuleVoServiceExpandImpl"})
public class GenerateCodeRuleVoServiceImpl
implements GenerateCodeRuleVoService {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeRuleVoServiceImpl.class);
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private RedisService redisService;

    public List<String> generateCode(String ruleCode, long number) {
        Assert.hasLength((String)ruleCode, (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((number >= 1L ? 1 : 0) != 0, (String)"\u81f3\u5c11\u751f\u6210\u4e00\u4e2a\u7f16\u7801");
        String redisKey = String.format("lock:tenant:generateRuleCode:business:%s:%s", TenantUtils.getTenantCode(), ruleCode);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, 15, 15, TimeUnit.SECONDS);
            Validate.isTrue((boolean)locked, (String)"\u751f\u6210\u7f16\u7801\u89c4\u5219\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            ArrayList<String> list = new ArrayList<String>();
            Object obj = this.redisService.hGet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCode);
            Assert.notNull((Object)obj, (String)("\u7f16\u7801\u89c4\u5219[" + ruleCode + "]\u4e0d\u5b58\u5728,\u6216\u672a\u540c\u6b65\u5230\u7f13\u5b58,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
            GenerateCodeRuleVo ruleVo = (GenerateCodeRuleVo)obj;
            Assert.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(ruleVo.getDelFlag()), (String)("\u7f16\u7801\u89c4\u5219[" + ruleCode + "]\u5df2\u88ab\u903b\u8f91\u5220\u9664!"));
            Assert.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(ruleVo.getEnableStatus()), (String)("\u7f16\u7801\u89c4\u5219[" + ruleCode + "]\u5df2\u88ab\u7981\u7528"));
            Date now = new Date();
            String prefix = StringUtils.stripToEmpty((String)ruleVo.getPrefix());
            String dateStr = "";
            if (StringUtils.isNotEmpty((CharSequence)ruleVo.getDateFormat())) {
                SimpleDateFormat sdf = new SimpleDateFormat(ruleVo.getDateFormat());
                dateStr = sdf.format(now);
            }
            int expirationTimes = 0;
            TimeUnit timeUnit = TimeUnit.DAYS;
            boolean restCurrentValueFormat = false;
            if (StringUtils.isNotEmpty((CharSequence)dateStr) && BooleanEnum.TRUE.getCapital().equals(ruleVo.getRestCurrentValueFormat())) {
                Assert.isTrue((boolean)GenerateCodeRuleConstant.DATE_FORMAT_SET.contains(ruleVo.getDateFormat()), (String)("\u7f16\u7801\u89c4\u5219[" + ruleCode + "]\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e!"));
                restCurrentValueFormat = true;
                switch (ruleVo.getDateFormat()) {
                    case "yyyyMMdd": {
                        expirationTimes = 25;
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case "yyyyMM": {
                        expirationTimes = 32;
                        break;
                    }
                    case "yyyy": {
                        expirationTimes = 370;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u7f16\u7801\u89c4\u5219[" + ruleCode + "]\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e!");
                    }
                }
            }
            Long currentValue = null;
            if (restCurrentValueFormat) {
                String ruleKey = String.format(RuleCodeRedisEnum.RULE_CODE_DATE_FORMAT.getVal(), ruleCode, dateStr);
                currentValue = this.redisService.incr(ruleKey, number);
                this.redisService.expire(ruleKey, (long)expirationTimes, timeUnit);
            } else {
                currentValue = this.redisService.hIncr(RuleCodeRedisEnum.GEN_KEY.getVal(), ruleCode, Long.valueOf(number));
            }
            int numberLength = ruleVo.getCodeLength() - prefix.length() - dateStr.length();
            long begin = currentValue - number;
            int i = 1;
            while ((long)i <= number) {
                list.add(prefix + dateStr + String.format("%0" + numberLength + "d", ++begin));
                ++i;
            }
            ruleVo.setCurrentValue(currentValue);
            ruleVo.setGenerateDate(now);
            ruleVo.setRuleModule(this.applicationName);
            this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleVo.getRuleCode(), (Object)ruleVo);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u7f16\u7801\u89c4\u5219\u51fa\u9519\uff1a{}", (Object)ruleCode, (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (locked && this.redisMutexService.islock(redisKey)) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    public String generateCode(String ruleCode) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)ruleCode), (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> list = this.generateCode(ruleCode, 1L);
        if (ObjectUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return "";
    }
}

