//package com.biz.crm.common.rulecode.local.notifier;
//
//import com.baomidou.mybatisplus.core.toolkit.Assert;
//import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
//import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
//import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
//import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
//import com.biz.crm.common.rulecode.sdk.dto.RuleCodeEventDto;
//import com.biz.crm.common.rulecode.sdk.event.RuleCodeEventListener;
//import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
//import com.bizunited.nebula.common.util.tenant.TenantUtils;
//import com.google.common.collect.Lists;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.List;
//import java.util.Objects;
//
///**
// * 客户用户事件监听器用户
// *
// * @author hefan
// * @date 2022/09/14
// */
//@Service
//@Slf4j
//public class RuleCodeLogEventListener implements RuleCodeEventListener {
//
//    @Autowired(required = false)
//    private CrmBusinessLogVoService crmBusinessLogVoService;
//
//    @Override
//    public void onCreate(RuleCodeEventDto eventDto) {
//        List<GenerateCodeRuleVo> vos = this.findVoListByEventDto(eventDto);
//        if (CollectionUtils.isEmpty(vos)) {
//            return;
//        }
//        vos.forEach(item -> {
//            try {
//                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
//                crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
//                crmBusinessLogDto.setOnlyKey(item.getId());
//                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setNewObject(item);
//                crmBusinessLogVoService.handleSave(crmBusinessLogDto);
//            } catch (Exception e) {
//                log.error("创建操作日志保存失败", e);
//            }
//        });
//
//    }
//
//    @Override
//    public void onUpdate(RuleCodeEventDto eventDto) {
//        List<GenerateCodeRuleVo> vos = this.findVoListByEventDto(eventDto);
//        if (CollectionUtils.isEmpty(vos)) {
//            return;
//        }
//        Assert.isTrue(vos.size() == 1, "更新操作日志单次只能保存一条记录");
//        GenerateCodeRuleVo original = eventDto.getOriginal();
//        GenerateCodeRuleVo newest = vos.get(0);
//        try {
//            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
//            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
//            crmBusinessLogDto.setOnlyKey(newest.getId());
//            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
//            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
//            crmBusinessLogDto.setNewObject(newest);
//            crmBusinessLogDto.setOldObject(original);
//            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
//        } catch (Exception e) {
//            log.error("更新操作日志保存失败", e);
//        }
//    }
//
//    @Override
//    public void onDisable(RuleCodeEventDto eventDto) {
//        List<GenerateCodeRuleVo> vos = this.findVoListByEventDto(eventDto);
//        if (CollectionUtils.isEmpty(vos)) {
//            return;
//        }
//        vos.forEach(item -> {
//            try {
//                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
//                crmBusinessLogDto.setOperationType(OperationTypeEunm.DISABLE.getDictCode());
//                crmBusinessLogDto.setOnlyKey(item.getId());
//                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setNewObject(item);
//                crmBusinessLogVoService.handleSave(crmBusinessLogDto);
//            } catch (Exception e) {
//                log.error("禁用操作日志保存失败", e);
//            }
//        });
//    }
//
//    @Override
//    public void onEnable(RuleCodeEventDto eventDto) {
//        List<GenerateCodeRuleVo> vos = this.findVoListByEventDto(eventDto);
//        if (CollectionUtils.isEmpty(vos)) {
//            return;
//        }
//        vos.forEach(item -> {
//            try {
//                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
//                crmBusinessLogDto.setOperationType(OperationTypeEunm.ENABLE.getDictCode());
//                crmBusinessLogDto.setOnlyKey(item.getId());
//                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setNewObject(item);
//                crmBusinessLogVoService.handleSave(crmBusinessLogDto);
//            } catch (Exception e) {
//                log.error("启用操作日志保存失败", e);
//            }
//        });
//    }
//
//    @Override
//    public void onDelete(RuleCodeEventDto eventDto) {
//        List<GenerateCodeRuleVo> vos = this.findVoListByEventDto(eventDto);
//        if (CollectionUtils.isEmpty(vos)) {
//            return;
//        }
//        vos.forEach(item -> {
//            try {
//                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
//                crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
//                crmBusinessLogDto.setOnlyKey(item.getId());
//                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
//                crmBusinessLogDto.setNewObject(item);
//                crmBusinessLogVoService.handleSave(crmBusinessLogDto);
//            } catch (Exception e) {
//                log.error("删除操作日志保存失败", e);
//            }
//        });
//    }
//
//    /**
//     * 获取用户信息
//     *
//     * @param userEventDto
//     * @return
//     */
//    private List<GenerateCodeRuleVo> findVoListByEventDto(RuleCodeEventDto userEventDto) {
//        List<GenerateCodeRuleVo> ruleVos = Lists.newArrayList();
//        if (Objects.isNull(userEventDto)) {
//            return ruleVos;
//        }
//        if (Objects.nonNull(userEventDto.getNewest())) {
//            ruleVos.add(userEventDto.getNewest());
//        }
//        if (CollectionUtils.isNotEmpty(userEventDto.getNewestList())) {
//            ruleVos.addAll(userEventDto.getNewestList());
//        }
//        return ruleVos;
//    }
//}
