package com.biz.crm.common.rulecode.local.repository;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.mapper.GenerateCodeRuleMapper;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;


/**
 * @author XXLsansui
 * @date 2024-01-24 11:09
 * @description：
 */
@Component
public class GenerateCodeRuleRepository extends ServiceImpl<GenerateCodeRuleMapper, GenerateCodeRuleEntity> {

    /**
     * 分页
     *
     * @param pageable
     * @param dto
     * @return
     */
    public Page<GenerateCodeRuleEntity> findByConditions(Pageable pageable, GenerateCodeRuleDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new GenerateCodeRuleDto());
        Page<GenerateCodeRuleEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.baseMapper.findByConditions(page, dto);
    }

    /**
     * 根据id查询编码规则详情
     *
     * @param id
     * @return
     */
    public GenerateCodeRuleEntity findById(String id) {
        return this.lambdaQuery()
                .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(GenerateCodeRuleEntity::getId, id)
                .one();
    }

    /**
     * 根据ruleCode查询编码规则详情
     *
     * @param ruleCode
     * @return
     */
    public GenerateCodeRuleEntity findByCode(String ruleCode) {
        return this.lambdaQuery()
                .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(GenerateCodeRuleEntity::getRuleCode, ruleCode)
                .one();
    }

    /**
     * 根据id集合查询
     *
     * @param ids
     * @return
     */
    public List<GenerateCodeRuleEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(GenerateCodeRuleEntity::getId, ids)
                .list();
    }
}
