/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.biz.crm.common.rulecode.sdk.service.GenerateCodeRuleVoService;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/generateCodeRule/generateCodeRule"})
@Api(tags={"\u7f16\u7801\u89c4\u5219"})
public class GenerateCodeRuleController {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeRuleController.class);
    @Autowired(required=false)
    private GenerateCodeRuleService generateCodeRuleService;
    @Autowired(required=false)
    private GenerateCodeRuleVoService generateCodeRuleVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<GenerateCodeRuleEntity>> findByConditions(@PageableDefault(value=50) Pageable pageable, GenerateCodeRuleDto dto) {
        try {
            Page<GenerateCodeRuleEntity> result = this.generateCodeRuleService.findByConditions(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u89c4\u5219\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public Result<GenerateCodeRuleVo> findById(@RequestParam(value="id") String id) {
        try {
            GenerateCodeRuleVo vo = this.generateCodeRuleService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={"create"})
    public Result<GenerateCodeRuleVo> create(@RequestBody GenerateCodeRuleDto dto) {
        try {
            GenerateCodeRuleVo current = this.generateCodeRuleService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"update"})
    public Result<GenerateCodeRuleVo> update(@RequestBody GenerateCodeRuleDto dto) {
        try {
            GenerateCodeRuleVo current = this.generateCodeRuleService.update(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.generateCodeRuleService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.generateCodeRuleService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.generateCodeRuleService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u7f16\u7801(\u4f20ids)")
    @PostMapping(value={"/reset"})
    public Result reset(@RequestBody List<String> ids) {
        try {
            this.generateCodeRuleService.reset(ids);
            return Result.ok((String)"\u91cd\u7f6e\u7f16\u7801\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u6b65\u7f16\u7801\u89c4\u5219(\u5168\u91cf)")
    @PostMapping(value={"/syncNumKey"})
    public Result syncNumKey(@RequestBody GenerateCodeRuleDto dto) {
        this.generateCodeRuleService.syncNumKey(dto);
        return Result.ok((String)"\u540c\u6b65\u6210\u529f");
    }

    @ApiOperation(value="\u751f\u6210\u591a\u4e2a\u7f16\u7801")
    @GetMapping(value={"/generateCode"})
    public Result<List<String>> generateCode(String ruleCode, long number) {
        return Result.ok((Object)this.generateCodeRuleVoService.generateCode(ruleCode, number));
    }
}

