/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;
import com.biz.crm.common.log.sdk.utils.BusinessLogUtil;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.repository.GenerateCodeRuleRepository;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.constant.GenerateCodeRuleConstant;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.biz.crm.common.rulecode.sdk.dto.RuleCodeEventDto;
import com.biz.crm.common.rulecode.sdk.enums.RuleCodeRedisEnum;
import com.biz.crm.common.rulecode.sdk.event.RuleCodeEventListener;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"GenerateCodeRuleServiceExpandImpl"})
public class GenerateCodeRuleServiceImpl
implements GenerateCodeRuleService {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeRuleServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeRuleRepository generateCodeRuleRepository;
    @Autowired(required=false)
    @Lazy
    private List<RuleCodeEventListener> eventListeners;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private RedisService redisService;

    @Override
    public Page<GenerateCodeRuleEntity> findByConditions(Pageable pageable, GenerateCodeRuleDto dto) {
        return this.generateCodeRuleRepository.findByConditions(pageable, dto);
    }

    @Override
    public GenerateCodeRuleVo findById(String id) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"\u8bf7\u9009\u62e9\u89c4\u5219\u7f16\u7801\u8be6\u60c5id!", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = this.generateCodeRuleRepository.findById(id);
        return (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GenerateCodeRuleVo create(GenerateCodeRuleDto dto) {
        Assert.notNull((Object)dto, (String)"\u65b0\u589e\u7f16\u7801\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        this.baseVerify(dto);
        GenerateCodeRuleEntity oldEntity = this.generateCodeRuleRepository.findByCode(dto.getRuleCode());
        Assert.isNull((Object)((Object)oldEntity), (String)("\u7f16\u7801\u89c4\u5219[" + dto.getRuleCode() + "]\u5df2\u5b58\u5728"));
        GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, GenerateCodeRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setAllInfoNull();
        this.generateCodeRuleRepository.save((Object)entity);
        GenerateCodeRuleVo newRuleVo = (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.syncToRedisVo(newRuleVo);
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewest((Object)newRuleVo);
        BusinessLogUtil.onCreate((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return newRuleVo;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewest(newRuleVo);
        this.eventListeners.forEach(eventListener -> eventListener.onCreate(eventDto));
        return newRuleVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GenerateCodeRuleVo update(GenerateCodeRuleDto dto) {
        Assert.notNull((Object)dto, (String)"\u65b0\u589e\u7f16\u7801\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.baseVerify(dto);
        GenerateCodeRuleEntity oldEntity = this.generateCodeRuleRepository.findById(dto.getId());
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)oldEntity)), (String)"\u5f53\u524did\u5bf9\u5e94\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        if (ObjectUtils.isNotEmpty((Object)dto.getCurrentValue())) {
            Validate.isTrue((dto.getCurrentValue() >= oldEntity.getCurrentValue() ? 1 : 0) != 0, (String)"\u5f53\u524d\u503c\u4e0d\u80fd\u6539\u5c0f!", (Object[])new Object[0]);
        }
        GenerateCodeRuleVo oldRuleVo = (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.isTrue((boolean)dto.getRuleCode().equals(oldEntity.getRuleCode()), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, GenerateCodeRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setModifyInfoToNull();
        this.generateCodeRuleRepository.saveOrUpdate((Object)entity);
        GenerateCodeRuleVo newRuleVo = (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.syncToRedisVo(newRuleVo);
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewest((Object)newRuleVo);
        logDto.setOriginal((Object)oldRuleVo);
        BusinessLogUtil.onUpdate((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return newRuleVo;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewest(newRuleVo);
        eventDto.setOriginal(oldRuleVo);
        this.eventListeners.forEach(eventListener -> eventListener.onUpdate(eventDto));
        return newRuleVo;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7f16\u7801\u89c4\u5219");
        List<GenerateCodeRuleEntity> entityList = this.generateCodeRuleRepository.findByIds(ids);
        Assert.notEmpty(entityList, (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728");
        List ruleCodes = entityList.stream().map(GenerateCodeRuleEntity::getRuleCode).collect(Collectors.toList());
        entityList.forEach(item -> {
            Assert.isTrue((boolean)EnableStatusEnum.DISABLE.getCode().equals(item.getEnableStatus()), (String)("\u7f16\u7801\u89c4\u5219[" + item.getRuleCode() + "]\u9700\u8981\u5148\u7981\u7528,\u624d\u80fd\u5220\u9664!"));
            item.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            item.setRemark(item.getRuleCode());
            item.setRuleCode(item.getId());
            item.setModifyInfoToNull();
        });
        this.generateCodeRuleRepository.updateBatchById(entityList);
        this.redisService.hDel(RuleCodeRedisEnum.GEN_KEY.getVal(), ruleCodes.toArray());
        this.redisService.hDel(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCodes.toArray());
        List newRuleVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, GenerateCodeRuleEntity.class, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewestList(newRuleVoList);
        BusinessLogUtil.onDelete((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewestList(newRuleVoList);
        this.eventListeners.forEach(eventListener -> eventListener.onDelete(eventDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u7f16\u7801\u89c4\u5219");
        List<GenerateCodeRuleEntity> entityList = this.generateCodeRuleRepository.findByIds(ids);
        Assert.notEmpty(entityList, (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728");
        entityList.forEach(item -> {
            Assert.isTrue((!EnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus()) ? 1 : 0) != 0, (String)("\u7f16\u7801\u89c4\u5219[" + item.getRuleCode() + "]\u5df2\u542f\u7528"));
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setModifyInfoToNull();
        });
        this.generateCodeRuleRepository.updateBatchById(entityList);
        List newRuleVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, GenerateCodeRuleEntity.class, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        newRuleVoList.forEach(item -> this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), item.getRuleCode(), item));
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewestList(newRuleVoList);
        BusinessLogUtil.onEnable((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewestList(newRuleVoList);
        this.eventListeners.forEach(eventListener -> eventListener.onEnable(eventDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u7f16\u7801\u89c4\u5219");
        List<GenerateCodeRuleEntity> entityList = this.generateCodeRuleRepository.findByIds(ids);
        Assert.notEmpty(entityList, (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728");
        entityList.forEach(item -> {
            Assert.isTrue((!EnableStatusEnum.DISABLE.getCode().equals(item.getEnableStatus()) ? 1 : 0) != 0, (String)("\u7f16\u7801\u89c4\u5219[" + item.getRuleCode() + "]\u5df2\u7981\u7528"));
            item.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            item.setModifyInfoToNull();
        });
        this.generateCodeRuleRepository.updateBatchById(entityList);
        List newRuleVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, GenerateCodeRuleEntity.class, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        newRuleVoList.forEach(item -> this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), item.getRuleCode(), item));
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewestList(newRuleVoList);
        BusinessLogUtil.onDisable((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewestList(newRuleVoList);
        this.eventListeners.forEach(eventListener -> eventListener.onDisable(eventDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reset(List<String> ids) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u8981\u91cd\u7f6e\u7684\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u5f71\u54cd\u8f83\u5927\uff0c\u6682\u4e0d\u652f\u6301\u6279\u91cf\u91cd\u7f6e", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = this.generateCodeRuleRepository.findById(ids.get(0));
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)entity)), (String)"\u91cd\u7f6e\u7684\u7f16\u7801\u89c4\u5219\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        GenerateCodeRuleVo oldRuleVo = (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        entity.setCurrentValue(entity.getInitialValue() - 1L);
        entity.setModifyInfoToNull();
        if (StringUtils.isNotEmpty((CharSequence)entity.getDateFormat()) && BooleanEnum.TRUE.getCapital().equals(entity.getRestCurrentValueFormat())) {
            SimpleDateFormat sdf = new SimpleDateFormat(entity.getDateFormat());
            String dateStr = sdf.format(new Date());
            boolean hasKey = this.redisService.hasKey(RuleCodeRedisEnum.GEN_KEY.getVal() + entity.getRuleCode() + ":" + dateStr);
            Validate.isTrue((!hasKey ? 1 : 0) != 0, (String)"\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u4e3a\u7a7a\u4e14\u662f\u5426\u6309\u65f6\u95f4\u7ef4\u5ea6\u91cd\u7f6e\u4e3a\u662f\uff0c\u65e0\u6cd5\u91cd\u7f6e!", (Object[])new Object[0]);
        }
        this.generateCodeRuleRepository.updateById((Object)entity);
        GenerateCodeRuleVo newRuleVo = (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.syncToRedisVo(newRuleVo);
        if (StringUtils.isNotEmpty((CharSequence)newRuleVo.getDateFormat()) && BooleanEnum.TRUE.getCapital().equals(newRuleVo.getRestCurrentValueFormat())) {
            long expirationTimes;
            TimeUnit timeUnit = TimeUnit.DAYS;
            switch (newRuleVo.getDateFormat()) {
                case "yyyyMMdd": {
                    expirationTimes = 25L;
                    timeUnit = TimeUnit.HOURS;
                    break;
                }
                case "yyyyMM": {
                    expirationTimes = 32L;
                    break;
                }
                case "yyyy": {
                    expirationTimes = 370L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u7f16\u7801\u89c4\u5219[" + newRuleVo.getRuleCode() + "]\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e!");
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat(newRuleVo.getDateFormat());
            String dateStr = sdf.format(new Date());
            String ruleKey = String.format(RuleCodeRedisEnum.RULE_CODE_DATE_FORMAT.getVal(), newRuleVo.getRuleCode(), dateStr);
            this.redisService.set(ruleKey, (Object)newRuleVo.getCurrentValue(), expirationTimes, timeUnit);
            this.redisService.expire(ruleKey, expirationTimes, timeUnit);
        }
        BusinessLogEventDto logDto = new BusinessLogEventDto();
        logDto.setNewest((Object)newRuleVo);
        logDto.setOriginal((Object)oldRuleVo);
        BusinessLogUtil.onDelete((BusinessLogEventDto)logDto);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        RuleCodeEventDto eventDto = new RuleCodeEventDto();
        eventDto.setNewest(newRuleVo);
        eventDto.setOriginal(oldRuleVo);
        this.eventListeners.forEach(eventListener -> eventListener.onUpdate(eventDto));
    }

    private void syncToRedisVo(GenerateCodeRuleVo vo) {
        if (Objects.isNull(vo)) {
            return;
        }
        String ruleCode = vo.getRuleCode();
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return;
        }
        this.redisService.hSet(RuleCodeRedisEnum.GEN_KEY.getVal(), ruleCode, (Object)vo.getCurrentValue());
        this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCode, (Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncNumKey(GenerateCodeRuleDto dto) {
        PageRequest pageable = PageRequest.of((int)1, (int)400);
        int number = 1;
        dto = Optional.ofNullable(dto).orElse(new GenerateCodeRuleDto());
        Page<GenerateCodeRuleEntity> page = null;
        String redisLock = "rule_code:sync_lock";
        boolean isLock = this.redisMutexService.tryLock(redisLock, 1, 1, TimeUnit.MINUTES);
        Assert.isTrue((boolean)isLock, (String)"\u540c\u6b65\u6570\u636e\u65f6\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        try {
            do {
                page = this.findByConditions((Pageable)pageable, dto);
                ++number;
                pageable = pageable.next();
                if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
                    return;
                }
                Map<String, GenerateCodeRuleEntity> entityMap = page.getRecords().stream().collect(Collectors.toMap(GenerateCodeRuleEntity::getRuleCode, v -> v, (v1, v2) -> v1));
                List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getRecords(), GenerateCodeRuleEntity.class, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
                list.forEach(vo -> {
                    String ruleCode = vo.getRuleCode();
                    Object obj = this.redisService.hGet(RuleCodeRedisEnum.GEN_KEY.getVal(), ruleCode);
                    Long currentValue = vo.getCurrentValue();
                    if (obj != null) {
                        Integer redisValue = (Integer)obj;
                        if (currentValue < (long)redisValue.intValue()) {
                            currentValue = (long)redisValue;
                            GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)((Object)entityMap.get(ruleCode)));
                            if (Objects.nonNull((Object)entity)) {
                                entity.setCurrentValue(currentValue);
                                entity.setModifyInfoToNull();
                                entityMap.put(ruleCode, entity);
                            }
                        }
                    }
                    this.redisService.hSet(RuleCodeRedisEnum.GEN_KEY.getVal(), ruleCode, (Object)currentValue);
                    vo.setCurrentValue(currentValue);
                    Object genVo = this.redisService.hGet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCode);
                    if (genVo == null) {
                        this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCode, vo);
                    } else {
                        try {
                            GenerateCodeRuleVo oldVo = (GenerateCodeRuleVo)genVo;
                            GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)((Object)entityMap.get(ruleCode)));
                            if (Objects.nonNull((Object)entity)) {
                                entity.setGenerateDate(oldVo.getGenerateDate());
                                if (StringUtils.isEmpty((CharSequence)entity.getRuleModule())) {
                                    entity.setRuleModule(oldVo.getRuleModule());
                                } else if (!entity.getRuleModule().equals(oldVo.getRuleModule())) {
                                    entity.setRuleModule("crm-sys");
                                }
                                vo.setGenerateDate(entity.getGenerateDate());
                                vo.setRuleModule(entity.getRuleModule());
                                entity.setModifyInfoToNull();
                                entityMap.put(ruleCode, entity);
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        this.redisService.hSet(RuleCodeRedisEnum.GEN_VO.getVal(), ruleCode, vo);
                    }
                });
                this.generateCodeRuleRepository.updateBatchById(new ArrayList<GenerateCodeRuleEntity>(entityMap.values()));
            } while (page.hasNext() && number <= 50);
        }
        finally {
            this.redisMutexService.unlock(redisLock);
        }
    }

    private void baseVerify(GenerateCodeRuleDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getRuleCode()), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto.getCodeLength()), (String)"\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getPrefix())) {
            String oldPrefix = dto.getPrefix();
            dto.setPrefix(oldPrefix.replaceAll("\\s+", ""));
            Assert.isTrue((boolean)oldPrefix.equals(dto.getPrefix()), (String)("\u524d\u7f00[" + oldPrefix + "]\u4e0d\u5408\u6cd5"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getDateFormat())) {
            String oldDateFormat = dto.getDateFormat();
            dto.setDateFormat(oldDateFormat.replaceAll("[^a-zA-Z]", ""));
            Assert.isTrue((boolean)oldDateFormat.equals(dto.getDateFormat()), (String)("\u65f6\u95f4\u6233\u683c\u5f0f[" + oldDateFormat + "]\u4e0d\u5408\u6cd5"));
            Assert.hasLength((String)dto.getRestCurrentValueFormat(), (String)"\u662f\u5426\u6309\u65f6\u95f4\u7ef4\u5ea6\u91cd\u7f6e\u5f53\u524d\u503c[\u662f/\u5426]\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((BooleanEnum.FALSE.getCapital().equals(dto.getRestCurrentValueFormat()) || BooleanEnum.TRUE.getCapital().equals(dto.getRestCurrentValueFormat()) ? 1 : 0) != 0, (String)"\u662f\u5426\u6309\u65f6\u95f4\u7ef4\u5ea6\u91cd\u7f6e\u5f53\u524d\u503c\u4e0d\u5408\u6cd5");
            String dateFormat = dto.getDateFormat();
            Assert.isTrue((boolean)GenerateCodeRuleConstant.DATE_FORMAT_SET.contains(dateFormat), (String)("\u65f6\u95f4\u6233\u683c\u5f0f\u76ee\u524d\u53ea\u652f\u6301" + GenerateCodeRuleConstant.DATE_FORMAT_SET));
        } else {
            Assert.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(dto.getRestCurrentValueFormat()), (String)"\u65f6\u95f4\u6233\u683c\u5f0f\u4e3a\u7a7a\u65f6,\u662f\u5426\u6309\u65f6\u95f4\u7ef4\u5ea6\u91cd\u7f6e\u5fc5\u987b\u662f[\u5426]");
            dto.setRestCurrentValueFormat(BooleanEnum.FALSE.getCapital());
        }
        Validate.isTrue((dto.getCodeLength() <= 32 ? 1 : 0) != 0, (String)"\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto.getInitialValue()), (String)"                  ", (Object[])new Object[0]);
        Validate.isTrue((dto.getInitialValue() > 0L ? 1 : 0) != 0, (String)"\u8d77\u59cb\u503c\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        int lengthWithoutNumber = (StringUtils.isEmpty((CharSequence)dto.getPrefix()) ? 0 : dto.getPrefix().length()) + (StringUtils.isEmpty((CharSequence)dto.getDateFormat()) ? 0 : dto.getDateFormat().length());
        Validate.isTrue((dto.getCodeLength() > lengthWithoutNumber ? 1 : 0) != 0, (String)"\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u524d\u7f00\u548c\u65f6\u95f4\u6233\u957f\u5ea6\u4e4b\u548c", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getDateFormat())) {
            try {
                new SimpleDateFormat(dto.getDateFormat());
            }
            catch (Exception e) {
                Validate.isTrue((boolean)false, (String)("\u65f6\u95f4\u6233\u683c\u5f0f" + dto.getDateFormat() + "\u4e0d\u5408\u6cd5"), (Object[])new Object[0]);
            }
        }
    }
}

