/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.local.task;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.rulecode.local.config.RuleCodeSyncConfig;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class RuleCodeSyncCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RuleCodeSyncCornTask.class);
    private static final String DEFAULT_CRON = "0 10 6 * * ?";
    private String cron = "0 10 6 * * ?";
    private boolean executionCron;
    @Autowired(required=false)
    private RuleCodeSyncConfig ruleCodeSyncConfig;
    @Autowired(required=false)
    private GenerateCodeRuleService generateCodeRuleService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String APPLICATION_NAME = "crm-mdm";

    @PostConstruct
    private void setRuleCodeSyncInfo() {
        this.setCron(this.ruleCodeSyncConfig.getExecutionCron());
        this.executionCron = this.ruleCodeSyncConfig.isOpenSync();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::ruleCodeSync, triggerContext -> {
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     \u540c\u6b65\u7f16\u7801\u89c4\u5219\u540c\u6b65\u89c4\u5219:\u539f\u6765\u7684cron\uff1a[{}]]\u66f4\u65b0\u540e\u7684cron\uff1a[{}]     <=====", (Object)this.cron, (Object)cron);
        this.cron = cron;
    }

    private void ruleCodeSync() {
        if (!this.executionCron) {
            log.info("====>     \u7f16\u7801\u89c4\u5219\u540c\u6b65\u4efb\u52a1\u672a\u5f00\u542f     <=====");
            return;
        }
        this.loginUserService.refreshAuthentication(null);
        this.generateCodeRuleService.syncNumKey(new GenerateCodeRuleDto());
    }
}

