package com.biz.crm.common.rulecode.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author XXLsansui
 * @date 2024-01-24 10:14
 * @description：编码规则实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("crm_generate_code_rule")
@ApiModel(value = "crm_generate_code_rule", description = "编码规则实体类")
@Table(name = "crm_generate_code_rule", indexes = {@Index(name = "crm_g_code_rule_idx1", columnList = "tenant_code,rule_code", unique = true), @Index(name = "crm_g_code_rule_idx2", columnList = "generate_date,id", unique = false),})
@org.hibernate.annotations.Table(appliesTo = "crm_generate_code_rule", comment = "编码规则实体类")
public class GenerateCodeRuleEntity extends TenantFlagOpEntity {

    private static final long serialVersionUID = 3739789099248011982L;

    @ApiModelProperty("业务key")
    @TableField(value = "rule_code")
    @Column(name = "rule_code", columnDefinition = "VARCHAR2(64) ")
    private String ruleCode;

    @ApiModelProperty("前缀")
    @TableField(value = "prefix")
    @Column(name = "prefix", columnDefinition = "VARCHAR2(64) ")
    private String prefix;

    @ApiModelProperty("时间戳格式")
    @TableField(value = "date_format")
    @Column(name = "date_format", columnDefinition = "VARCHAR2(64) ")
    private String dateFormat;

    @ApiModelProperty("是否按时间维度重置;时间戳格式不为空时生效")
    @TableField(value = "rest_current_value_Format")
    @Column(name = "rest_current_value_Format", columnDefinition = "VARCHAR2(2) DEFAULT 'N'")
    private String restCurrentValueFormat;

    @ApiModelProperty("编码总长度")
    @TableField(value = "code_length")
    @Column(name = "code_length", columnDefinition = "INT NOT NULL")
    private Integer codeLength;

    @ApiModelProperty("规则描述")
    @TableField(value = "rule_description")
    @Column(name = "rule_description", columnDefinition = "VARCHAR2(256) ")
    private String ruleDescription;

    @ApiModelProperty("起始值")
    @TableField(value = "initial_value")
    @Column(name = "initial_value", columnDefinition = "INT NOT NULL ")
    private Long initialValue;

    @ApiModelProperty("当前值")
    @TableField(value = "current_value")
    @Column(name = "current_value", columnDefinition = "INT NOT NULL")
    private Long currentValue;

    @ApiModelProperty("生成时间")
    @TableField(value = "generate_date")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "generate_date", columnDefinition = "TIMESTAMP(3)")
    private Date generateDate;

    @ApiModelProperty("所属模块")
    @TableField(value = "rule_module")
    @Column(name = "rule_module", columnDefinition = "VARCHAR2(64)")
    private String ruleModule;

}
