package com.biz.crm.common.rulecode.local.task;


import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.rulecode.local.config.RuleCodeSyncConfig;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 清理业务操作ES日志
 *
 * @author huxmld
 * @version v1.0.0
 * @describe 简述
 * @date 2024.03.01 18:01
 */
@EnableScheduling
@Component
@Slf4j
public class RuleCodeSyncCornTask implements SchedulingConfigurer {

    private static final String DEFAULT_CRON = "0 10 6 * * ?";

    private String cron = DEFAULT_CRON;
    private boolean executionCron;

    @Autowired(required = false)
    private RuleCodeSyncConfig ruleCodeSyncConfig;

    @Autowired(required = false)
    private GenerateCodeRuleService generateCodeRuleService;

    @Autowired(required = false)
    private LoginUserService loginUserService;
    /**
     * 清理对外日志应用-必须是 crm-mdm
     */
    private final static String APPLICATION_NAME = "crm-mdm";

    /**
     * 根据配置文件参数,系统启动完成后,自动设置自定义定时任务执行计划
     */
    @PostConstruct
    private void setRuleCodeSyncInfo() {
        this.setCron(ruleCodeSyncConfig.getExecutionCron());
        executionCron = ruleCodeSyncConfig.isOpenSync();
    }

    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::ruleCodeSync, triggerContext -> {
            CronTrigger trigger = new CronTrigger(cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     同步编码规则同步规则:原来的cron：[{}]]更新后的cron：[{}]     <=====", this.cron, cron);
        this.cron = cron;
    }

    /**
     * 同步编码规则
     */
    private void ruleCodeSync() {
        if (!executionCron) {
            log.info("====>     编码规则同步任务未开启     <=====");
            return;
        }
        loginUserService.refreshAuthentication(null);
        generateCodeRuleService.syncNumKey(new GenerateCodeRuleDto());
    }

}
