/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.repository.GenerateCodeRuleRepository;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"GenerateCodeRuleServiceExpandImpl"})
public class GenerateCodeRuleServiceImpl
implements GenerateCodeRuleService {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeRuleServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeRuleRepository generateCodeRuleRepository;

    @Override
    public Page<GenerateCodeRuleEntity> findByConditions(Pageable pageable, GenerateCodeRuleDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new GenerateCodeRuleDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return this.generateCodeRuleRepository.findByConditions((Page<GenerateCodeRuleEntity>)page, dto);
    }

    @Override
    public GenerateCodeRuleVo findById(String id) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"\u8bf7\u9009\u62e9\u89c4\u5219\u7f16\u7801\u8be6\u60c5id!", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = this.generateCodeRuleRepository.findById(id);
        return (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public GenerateCodeRuleVo create(GenerateCodeRuleDto dto) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto), (String)"\u65b0\u589e\u7f16\u7801\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        this.createVerify(dto);
        GenerateCodeRuleEntity oldEntity = this.generateCodeRuleRepository.findByCode(dto.getRuleCode());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)oldEntity)), (String)"\u7f16\u7801\u89c4\u5219key\u5df2\u5b58\u5728", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, GenerateCodeRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.generateCodeRuleRepository.save((Object)entity);
        return (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public GenerateCodeRuleVo update(GenerateCodeRuleDto dto) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto), (String)"\u7f16\u8f91\u7f16\u7801\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        this.createVerify(dto);
        GenerateCodeRuleEntity oldEntity = this.generateCodeRuleRepository.findById(dto.getId());
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)oldEntity)), (String)"\u5f53\u524did\u5bf9\u5e94\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        if (ObjectUtils.isNotEmpty((Object)dto.getCurrentValue())) {
            Validate.isTrue((dto.getCurrentValue() >= oldEntity.getCurrentValue() ? 1 : 0) != 0, (String)"\u5f53\u524d\u503c\u4e0d\u80fd\u6539\u5c0f!", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)dto.getRuleCode().equals(oldEntity.getRuleCode()), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = (GenerateCodeRuleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, GenerateCodeRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.generateCodeRuleRepository.saveOrUpdate((Object)entity);
        return (GenerateCodeRuleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, GenerateCodeRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7f16\u7801\u89c4\u5219", (Object[])new Object[0]);
        this.generateCodeRuleRepository.deleteBatch(ids);
    }

    @Override
    @Transactional
    public void reset(List<String> ids) {
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u8981\u91cd\u7f6e\u7684\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u5f71\u54cd\u8f83\u5927\uff0c\u6682\u4e0d\u652f\u6301\u6279\u91cf\u91cd\u7f6e", (Object[])new Object[0]);
        GenerateCodeRuleEntity entity = this.generateCodeRuleRepository.findById(ids.get(0));
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)entity)), (String)"\u91cd\u7f6e\u7684\u7f16\u7801\u89c4\u5219\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        entity.setCurrentValue(entity.getCurrentValue() - 1L);
        this.generateCodeRuleRepository.saveOrUpdate((Object)entity);
    }

    private void createVerify(GenerateCodeRuleDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getRuleCode()), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto.getCodeLength()), (String)"\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getCodeLength() <= 32 ? 1 : 0) != 0, (String)"\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dto.getInitialValue()), (String)"\u8d77\u59cb\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getInitialValue() > 0L ? 1 : 0) != 0, (String)"\u8d77\u59cb\u503c\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        int lengthWithoutNumber = (StringUtils.isEmpty((CharSequence)dto.getPrefix()) ? 0 : dto.getPrefix().length()) + (StringUtils.isEmpty((CharSequence)dto.getDateFormat()) ? 0 : dto.getDateFormat().length());
        Validate.isTrue((dto.getCodeLength() > lengthWithoutNumber ? 1 : 0) != 0, (String)"\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u524d\u7f00\u548c\u65f6\u95f4\u6233\u957f\u5ea6\u4e4b\u548c", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getDateFormat())) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dto.getDateFormat());
            }
            catch (Exception e) {
                Validate.isTrue((boolean)false, (String)("\u65f6\u95f4\u6233\u683c\u5f0f" + dto.getDateFormat() + "\u4e0d\u5408\u6cd5"), (Object[])new Object[0]);
            }
        }
    }
}

