package com.biz.crm.common.rulecode.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.service.GenerateCodeRuleService;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author XXLsansui
 * @date 2024-01-24 10:14
 * @description：编码规则Controller
 */
@Slf4j
@RestController
@RequestMapping("/v1/generateCodeRule/generateCodeRule")
@Api(tags = "crm2.0-生成编码规则")
public class GenerateCodeRuleController {

  @Autowired
  private GenerateCodeRuleService generateCodeRuleService;

  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param dto      查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<GenerateCodeRuleEntity>> findByConditions(@PageableDefault(50) Pageable pageable, GenerateCodeRuleDto dto) {
    try {
      Page<GenerateCodeRuleEntity> result = this.generateCodeRuleService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看规则详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "查看规则详情")
  @GetMapping(value = {"/findById"})
  public Result<GenerateCodeRuleVo> findById(@RequestParam("id") String id) {
    try {
      GenerateCodeRuleVo vo = this.generateCodeRuleService.findById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "create")
  public Result<GenerateCodeRuleVo> create(@RequestBody GenerateCodeRuleDto dto) {
    try {
      GenerateCodeRuleVo current = this.generateCodeRuleService.create(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "更新")
  @PostMapping(value = "update")
  public Result<GenerateCodeRuleVo> update(@RequestBody GenerateCodeRuleDto dto) {
    try {
      GenerateCodeRuleVo current = this.generateCodeRuleService.update(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.generateCodeRuleService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 重置
   */
  @ApiOperation(value = "重置编码(传ids)")
  @PostMapping("/reset")
  public Result<?> reset(@RequestParam("ids") List<String> ids) {
    try {
      this.generateCodeRuleService.reset(ids);
      return Result.ok("重置编码成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
