package com.biz.crm.common.rulecode.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.mapper.GenerateCodeRuleMapper;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * @author XXLsansui
 * @date 2024-01-24 11:09
 * @description：
 */
@Component
public class GenerateCodeRuleRepository extends ServiceImpl<GenerateCodeRuleMapper, GenerateCodeRuleEntity> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<GenerateCodeRuleEntity> findByConditions(Page<GenerateCodeRuleEntity> page, GenerateCodeRuleDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id查询编码规则详情
   *
   * @param id
   * @return
   */
  public GenerateCodeRuleEntity findById(String id) {
    return this.lambdaQuery()
        .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(GenerateCodeRuleEntity::getId, id)
        .one();
  }

  /**
   * 根据ruleCode查询编码规则详情
   *
   * @param ruleCode
   * @return
   */
  public GenerateCodeRuleEntity findByCode(String ruleCode) {
    return this.lambdaQuery()
        .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(GenerateCodeRuleEntity::getRuleCode, ruleCode)
        .one();
  }

  /**
   * 根据id集合删除编码规则
   *
   * @param ids
   * @return
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(GenerateCodeRuleEntity::getTenantCode, TenantUtils.getTenantCode())
        .in(GenerateCodeRuleEntity::getId, ids)
        .remove();
  }

}
