package com.biz.crm.common.rulecode.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author XXLsansui
 * @date 2024-01-24 10:14
 * @description：编码规则实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("generate_code_rule")
@ApiModel(value = "generate_code_rule", description = "编码规则实体类")
@Table(
    name = "generate_code_rule",
    indexes = {
        @Index(name = "generate_code_rule_index1", columnList = "tenant_code,rule_code", unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "generate_code_rule", comment = "编码规则实体类")
public class GenerateCodeRuleEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 3739789099248011982L;

  /**
   * 业务key
   */
  @ApiModelProperty("业务key")
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 64, columnDefinition = "varchar(64) COMMENT '业务key'")
  private String ruleCode;

  /**
   * 前缀
   */
  @ApiModelProperty("前缀")
  @TableField(value = "prefix")
  @Column(name = "prefix", length = 64, columnDefinition = "varchar(64) COMMENT '前缀'")
  private String prefix;

  /**
   * 时间戳格式
   */
  @ApiModelProperty("时间戳格式")
  @TableField(value = "date_format")
  @Column(name = "date_format", length = 64, columnDefinition = "varchar(64) COMMENT '时间戳格式'")
  private String dateFormat;

  /**
   * 编码总长度
   */
  @ApiModelProperty("编码总长度")
  @TableField(value = "code_length")
  @Column(name = "code_length", length = 10, columnDefinition = "INT(10) NOT NULL COMMENT '编码总长度'")
  private Integer codeLength;

  /**
   * 规则描述
   */
  @ApiModelProperty("规则描述")
  @TableField(value = "rule_description")
  @Column(name = "rule_description", length = 64, columnDefinition = "varchar(64) COMMENT '规则描述'")
  private String ruleDescription;

  /**
   * 起始值
   */
  @ApiModelProperty("起始值")
  @TableField(value = "initial_value")
  @Column(name = "initial_value", length = 20, columnDefinition = "INT(20) NOT NULL COMMENT '起始值'")
  private Long initialValue;

  /**
   * 当前值
   */
  @ApiModelProperty("当前值")
  @TableField(value = "current_value")
  @Column(name = "current_value", length = 20, columnDefinition = "INT(20) NOT NULL COMMENT '当前值'")
  private Long currentValue;

  /**
   * 生成时间
   */
  @ApiModelProperty("生成时间")
  @TableField(value = "generate_date")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "generate_date", columnDefinition = "datetime COMMENT '生成时间'")
  private Date generateDate;

  /**
   * 所属模块
   */
  @ApiModelProperty("所属模块")
  @TableField(value = "rule_module")
  @Column(name = "rule_module", length = 64, columnDefinition = "varchar(64) COMMENT '所属模块'")
  private String ruleModule;

}
