package com.biz.crm.common.rulecode.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.sdk.dto.GenerateCodeRuleDto;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 编码规则接口
 *
 * @author XXLsansui
 * @date 2024-01-24 10:14
 */
public interface GenerateCodeRuleService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<GenerateCodeRuleEntity> findByConditions(Pageable pageable, GenerateCodeRuleDto dto);


  /**
   * 查看规则详情
   *
   * @param id ID
   * @return
   */
  GenerateCodeRuleVo findById(String id);


  /**
   * 创建
   *
   * @param dto 请求参数dto
   * @return
   */
  GenerateCodeRuleVo create(GenerateCodeRuleDto dto);

  /**
   * 更新
   *
   * @param dto 请求参数dto
   * @return
   */
  GenerateCodeRuleVo update(GenerateCodeRuleDto dto);

  /**
   * 批量删除编码规则
   *
   * @param ids 编码规则id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 重置
   *
   * @param ids 编码规则集合
   */
  void reset(List<String> ids);

}

