/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.rulecode.local.service.internal;

import com.biz.crm.common.rulecode.local.entity.GenerateCodeRuleEntity;
import com.biz.crm.common.rulecode.local.repository.GenerateCodeRuleRepository;
import com.biz.crm.common.rulecode.sdk.service.GenerateCodeRuleVoService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"GenerateCodeRuleVoServiceExpandImpl"})
public class GenerateCodeRuleVoServiceImpl
implements GenerateCodeRuleVoService {
    private static final Logger log = LoggerFactory.getLogger(GenerateCodeRuleVoServiceImpl.class);
    @Autowired(required=false)
    private GenerateCodeRuleRepository generateCodeRuleRepository;
    @Autowired
    private RedisMutexService redisMutexService;

    public List<String> generateCodeList(String ruleCode, Integer number) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)ruleCode), (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)number), (String)"\u7f16\u7801\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((number >= 1 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u751f\u6210\u4e00\u4e2a\u7f16\u7801", (Object[])new Object[0]);
        String redisKey = String.format("lock:tenant:generateRuleCode:business:%s:%s", TenantUtils.getTenantCode(), ruleCode);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u751f\u6210\u7f16\u7801\u89c4\u5219\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            ArrayList<String> list = new ArrayList<String>();
            GenerateCodeRuleEntity rule = this.generateCodeRuleRepository.findByCode(ruleCode);
            Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)rule)), (String)("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219\uff1a" + ruleCode), (Object[])new Object[0]);
            Date now = new Date();
            String prefix = rule.getPrefix() == null ? "" : rule.getPrefix();
            String dateStr = "";
            if (StringUtils.isNotEmpty((CharSequence)rule.getDateFormat())) {
                SimpleDateFormat sdf = new SimpleDateFormat(rule.getDateFormat());
                dateStr = sdf.format(now);
            }
            Long currentValue = rule.getCurrentValue();
            int numberLength = rule.getCodeLength() - prefix.length() - dateStr.length();
            for (int i = 1; i <= number; ++i) {
                Long l = currentValue;
                Long l2 = currentValue = Long.valueOf(currentValue + 1L);
                list.add(prefix + dateStr + String.format("%0" + numberLength + "d", currentValue));
            }
            rule.setCurrentValue(currentValue);
            rule.setGenerateDate(now);
            this.generateCodeRuleRepository.updateById((Object)rule);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u7f16\u7801\u89c4\u5219\u51fa\u9519\uff1a{}, {}", (Object)ruleCode, (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (locked && this.redisMutexService.islock(redisKey)) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    public String generateCode(String ruleCode) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)ruleCode), (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> list = this.generateCodeList(ruleCode, 1);
        if (ObjectUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return "";
    }
}

