package com.biz.crm.common.rulecode.local.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 编码规则同步配置
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024.03.01 18:01
 */
@Configuration
@Data
public class RuleCodeSyncConfig {

    /**
     * 定时任务是否开启同步
     */
    @Value("${rule-code.open-sync:true}")
    private boolean openSync;

    /**
     * 定时任务执行时间
     */
    @Value("${rule-code.execution-cron:0 10 6 * * ?}")
    private String executionCron;

}
