package com.biz.crm.common.rulecode.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.common.rulecode.sdk.vo.GenerateCodeRuleVo;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 编码规则事件引擎事件通知Dto
 *
 * @author pengxi
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RuleCodeEventDto", description = "编码规则事件引擎事件通知Dto")
public class RuleCodeEventDto extends TenantDto implements NebulaEventDto {

    @ApiModelProperty("原始")
    private GenerateCodeRuleVo original;

    @ApiModelProperty("最新")
    private GenerateCodeRuleVo newest;

    @ApiModelProperty("最新集合")
    private List<GenerateCodeRuleVo> newestList;
}