package com.biz.crm.common.rulecode.sdk.event;


import com.biz.crm.common.rulecode.sdk.dto.RuleCodeEventDto;

/**
 * DictDataEventListener 编码规则数据操作事件通知
 *
 * @author pengxi
 */
public interface RuleCodeEventListener {
    /**
     * 当编码规则信息创建时触发
     *
     * @param eventDto 创建时的vo
     */
    default void onCreate(RuleCodeEventDto eventDto) {
    }

    /**
     * 当编码规则信息修改时触发
     *
     * @param eventDto
     */
    default void onUpdate(RuleCodeEventDto eventDto) {
    }

    /**
     * 当编码规则信息禁用时触发
     *
     * @param eventDto 禁用vo信息
     */
    default void onDisable(RuleCodeEventDto eventDto) {
    }

    /**
     * 当编码规则信息启用时触发
     *
     * @param eventDto 禁用vo信息
     */
    default void onEnable(RuleCodeEventDto eventDto) {
    }

    /**
     * 当编码规则信息删除时触发
     *
     * @param eventDto 删除vo信息
     */
    default void onDelete(RuleCodeEventDto eventDto) {
    }

}
