package com.biz.crm.common.rulecode.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author XXLsansui
 * @date 2024-01-24 10:14
 * @description：编码规则Vo
 */
@Data
@ApiModel(value = "GenerateCodeRuleVo", description = "编码规则Vo")
public class GenerateCodeRuleVo extends TenantFlagOpVo {

    private static final long serialVersionUID = 2465420654065446041L;

    @ApiModelProperty("业务key")
    private String ruleCode;

    @ApiModelProperty("前缀")
    private String prefix;

    @ApiModelProperty("时间戳格式")
    private String dateFormat;

    @ApiModelProperty("是否按时间维度重置;时间戳格式不为空时生效")
    private String restCurrentValueFormat;

    @ApiModelProperty("编码总长度")
    private Integer codeLength;

    @ApiModelProperty("规则描述")
    private String ruleDescription;

    @ApiModelProperty("起始值")
    private Long initialValue;

    @ApiModelProperty("当前值")
    private Long currentValue;

    @ApiModelProperty("生成时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date generateDate;

    @ApiModelProperty("所属模块")
    private String ruleModule;

}
