/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.verification.slider.util;

import cn.hutool.core.util.NumberUtil;
import com.biz.crm.common.verification.slider.core.CaptchaResult;
import com.biz.crm.common.verification.slider.core.CaptchaVo;
import com.biz.crm.common.verification.slider.core.PuzzleCaptcha;
import com.biz.crm.common.verification.slider.core.PuzzleGifCaptcha;
import com.biz.crm.common.verification.slider.redis.Cache;
import com.biz.crm.common.verification.slider.util.ImageConvertUtil;
import com.biz.crm.common.verification.slider.util.StrUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CaptchaUtil {
    private static final Logger log = LoggerFactory.getLogger(CaptchaUtil.class);
    @Autowired
    private Cache<Object> cache;
    private static final int X_OFFSET = 8;
    private static final int SPEED = 500;
    @Autowired
    private HttpServletRequest request;

    public CaptchaVo captcha(PuzzleCaptcha puzzleCaptcha) {
        String id = this.request.getRequestedSessionId();
        this.cache.remove("captcha:result:" + id);
        HashMap<String, Number> cacheMap = new HashMap<String, Number>();
        CaptchaVo captchaVo = new CaptchaVo();
        captchaVo.setImage1(ImageConvertUtil.toDataUri(puzzleCaptcha.getArtwork(), "png"));
        captchaVo.setImage2(ImageConvertUtil.toDataUri(puzzleCaptcha.getVacancy(), "png"));
        cacheMap.put("x", puzzleCaptcha.getX());
        cacheMap.put("time", System.currentTimeMillis());
        cacheMap.put("width", puzzleCaptcha.getWidth());
        this.cache.put("captcha:" + id, cacheMap, 300L);
        return captchaVo;
    }

    public CaptchaVo captcha(PuzzleGifCaptcha puzzleCaptcha) {
        String id = this.request.getRequestedSessionId();
        this.cache.remove("captcha:result:" + id);
        HashMap<String, Number> cacheMap = new HashMap<String, Number>();
        CaptchaVo captchaVo = new CaptchaVo();
        captchaVo.setImage1(ImageConvertUtil.toDataUri(puzzleCaptcha.getArtwork().toByteArray(), "png"));
        captchaVo.setImage2(ImageConvertUtil.toDataUri(puzzleCaptcha.getVacancy().toByteArray(), "png"));
        cacheMap.put("x", puzzleCaptcha.getX());
        cacheMap.put("time", System.currentTimeMillis());
        cacheMap.put("width", puzzleCaptcha.getWidth());
        this.cache.put("captcha:" + id, cacheMap, 300L);
        return captchaVo;
    }

    public CaptchaResult verify(Map<String, Object> map) {
        String id = this.request.getRequestedSessionId();
        CaptchaResult result = new CaptchaResult();
        result.setSuccess(false);
        String key = "captcha:" + id;
        Integer vx = StrUtil.toInt(map.get("x"));
        Integer width = StrUtil.toInt(map.get("width"), 1);
        Map cacheMap = (Map)this.cache.get(key);
        if (cacheMap == null) {
            return result;
        }
        Integer x = StrUtil.toInt(cacheMap.get("x"));
        Integer realWidth = StrUtil.toInt(cacheMap.get("width"));
        Long time = StrUtil.toLong(cacheMap.get("time"));
        long s = System.currentTimeMillis() - time;
        double ratio = NumberUtil.div((Number)realWidth, (Number)width).doubleValue();
        if (x == null || vx == null) {
            this.cache.remove(key);
            return result;
        }
        if (Math.abs((double)x.intValue() - (double)vx.intValue() * ratio) > 8.0 * ratio || s < 500L) {
            this.cache.remove(key);
            return result;
        }
        result.setSuccess(true);
        this.cache.remove(key);
        this.cache.put("captcha:result:" + id, result, 300L);
        return result;
    }
}

