package com.biz.crm.common.verification.slider.controller;

import cn.hutool.core.io.resource.ResourceUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.verification.slider.core.CaptchaResult;
import com.biz.crm.common.verification.slider.core.CaptchaVo;
import com.biz.crm.common.verification.slider.core.PuzzleCaptcha;
import com.biz.crm.common.verification.slider.util.CaptchaUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.awt.*;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Random;

/**
 * 滑块验证码通用接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("/v1/verification/slider")
@Api(tags = "滑块验证码通用接口")
public class VerificationSliderController {

  private static final String path = "/opt/sliderImages";

  @Value("${slider.imagePath}")
  private String imagesPath;

  @Autowired
  private CaptchaUtil captchaUtil;

  @ApiOperation(value = "获取图形验证码")
  @GetMapping("/getVerificationSlider")
  public Result<CaptchaVo> captcha() {
    try {
      //如果没有默认图片文件夹，则以默认文件夹作为图片路径
      if (StringUtils.isBlank(imagesPath)) {
        imagesPath = path;
      }
      File file = new File(imagesPath);
      List<File> files = Lists.newArrayList();
      this.findFile(files, file);
      PuzzleCaptcha puzzleCaptcha;
      if (CollectionUtils.isEmpty(files)) {
        //当没有从文件夹读取到图片文件，直接调用默认文件
        puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream("images/defaultImage.webp"));
      } else {
        //根据读取到的图片，随机生成一张图片
        int length = new Random().nextInt(files.size());
        puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream(files.get(length).getAbsolutePath()));
      }
      puzzleCaptcha.setImageQuality(Image.SCALE_AREA_AVERAGING);
      puzzleCaptcha.run();
      return Result.ok(captchaUtil.captcha(puzzleCaptcha));
    } catch (Exception e) {
      log.error("生成滑块异常", e);
      return Result.error("生成滑块验证图片失败！");
    }

  }

  @ApiOperation(value = "获取图形验证码")
  @PostMapping("/verifyVerificationSlider")
  public Result<CaptchaResult> verify(@RequestBody Map<String, Object> map) {
    return Result.ok(captchaUtil.verify(map));
  }

  /**
   * 循环获取文件目录下的文件
   *
   * @param files 文件列表
   * @param file  文件
   */
  private void findFile(List<File> files, File file) {
    File[] fs = file.listFiles();
    if (fs != null && fs.length > 0) {
      for (File f : fs) {
        if (f.isDirectory()) {
          // 文件夹 递归
          findFile(files, f);
        } else if (f.isFile()) {
          files.add(f);
        }
      }
    }
  }

  @ApiOperation(value = "获取图形验证码")
  @GetMapping("/getVerificationSliderById")
  public Result<CaptchaVo> captchaById(@RequestParam("id") String id) {
    Validate.notBlank(id, "请绑定当前登录验证id!");
    try {
      //如果没有默认图片文件夹，则以默认文件夹作为图片路径
      if (StringUtils.isBlank(imagesPath)) {
        imagesPath = path;
      }
      File file = new File(imagesPath);
      List<File> files = Lists.newArrayList();
      this.findFile(files, file);
      PuzzleCaptcha puzzleCaptcha;
      if (CollectionUtils.isEmpty(files)) {
        //当没有从文件夹读取到图片文件，直接调用默认文件
        puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream("images/defaultImage.webp"));
      } else {
        //根据读取到的图片，随机生成一张图片
        int length = new Random().nextInt(files.size());
        puzzleCaptcha = new PuzzleCaptcha(ResourceUtil.getStream(files.get(length).getAbsolutePath()));
      }
      puzzleCaptcha.setImageQuality(Image.SCALE_AREA_AVERAGING);
      puzzleCaptcha.run();
      return Result.ok(captchaUtil.captcha(puzzleCaptcha, id));
    } catch (Exception e) {
      log.error("生成滑块异常", e);
      return Result.error("生成滑块验证图片失败！");
    }
  }

}
