/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.verification.slider.redis;

import com.biz.crm.common.verification.slider.redis.Cache;
import com.biz.crm.common.verification.slider.util.ThrowableUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisCacheImpl<T>
implements Cache<T> {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheImpl.class);
    private final RedisTemplate<String, Object> redisTemplate;

    public RedisCacheImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void setExp(String key, long timeout) {
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean hasKey(String key) {
        Boolean b = this.redisTemplate.hasKey((Object)key);
        return b != null && b != false;
    }

    @Override
    public Object get(String key) {
        try {
            return this.redisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception e) {
            log.error(ThrowableUtil.stackTraceToString(e));
            return null;
        }
    }

    @Override
    public List<T> getList(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    @Override
    public void putAll(Map<String, T> map) {
        HashMap temp = new HashMap(map.size() * 2);
        map.forEach(temp::put);
        this.redisTemplate.opsForValue().multiSet(temp);
    }

    @Override
    public void removeAll(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    @Override
    public void put(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void put(String key, T value, long exp) {
        this.redisTemplate.opsForValue().set((Object)key, value, exp, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void prefixRemove(String key) {
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        if (keys != null) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    @Override
    public void clear() {
        Set keys = this.redisTemplate.keys((Object)"*");
        this.redisTemplate.delete((Collection)keys);
    }

    @Override
    public void putMap(String key, Object hashKey, Object hashValue) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, hashValue);
    }

    @Override
    public void putAllMap(String key, Map<String, T> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    @Override
    public T getMapValue(String key, String hashKey) {
        try {
            return (T)this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error(ThrowableUtil.stackTraceToString(e));
            return null;
        }
    }

    @Override
    public List<T> getMapValue(String key, List<String> hashKey) {
        try {
            return this.redisTemplate.opsForHash().multiGet((Object)key, hashKey);
        }
        catch (Exception e) {
            log.error(ThrowableUtil.stackTraceToString(e));
            return null;
        }
    }

    @Override
    public Map<String, T> getMap(String key) {
        try {
            HashOperations hashOperations = this.redisTemplate.opsForHash();
            return hashOperations.entries((Object)key);
        }
        catch (Exception e) {
            log.error(ThrowableUtil.stackTraceToString(e));
            return null;
        }
    }

    @Override
    public boolean hasMapKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    @Override
    public Long removeMapKey(String key, String ... hashKey) {
        return this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKey);
    }
}

