/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.verification.slider.core;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.NumberUtil;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.InvertAlphaFilter;
import com.jhlabs.image.ShadowFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;

public class PuzzleCaptcha {
    private static final int DEFAULT_WIDTH = 280;
    private static final Random RANDOM = new Random();
    private static Color color = new Color(255, 255, 255, 204);
    private static InvertAlphaFilter alphaFilter = new InvertAlphaFilter();
    private static int margin = 10;
    private int width = 280;
    private int height = 150;
    private int x;
    private int y;
    private int vwh = 30;
    private Image image;
    private Image artwork;
    private Image vacancy;
    private boolean isFast = false;
    private Color vacancyBorderColor;
    private float vacancyBorderWidth = 2.5f;
    private Color artworkBorderColor;
    private float artworkBorderWidth = 5.0f;
    private double maxRatio = 2.0;
    private int imageQuality = 4;

    public PuzzleCaptcha(File file) {
        this.image = ImgUtil.read((File)file);
    }

    public PuzzleCaptcha(String imageFilePath) {
        this.image = ImgUtil.read((String)imageFilePath);
    }

    public PuzzleCaptcha(Resource resource) {
        this.image = ImgUtil.read((Resource)resource);
    }

    public PuzzleCaptcha(InputStream imageStream) {
        this.image = ImgUtil.read((InputStream)imageStream);
    }

    public PuzzleCaptcha(ImageInputStream imageStream) {
        this.image = ImgUtil.read((ImageInputStream)imageStream);
    }

    public PuzzleCaptcha(Image image) {
        this.image = image;
    }

    public PuzzleCaptcha(byte[] bytes) {
        this.image = ImgUtil.read((InputStream)new ByteArrayInputStream(bytes));
    }

    private void init() {
        if (this.x == 0 || this.y == 0) {
            this.x = PuzzleCaptcha.random(this.vwh, this.width - this.vwh - margin);
            this.y = PuzzleCaptcha.random(margin, this.height - this.vwh - margin);
        }
    }

    public void run() {
        GeneralPath path;
        Image thumbnail;
        boolean isFast;
        this.init();
        int realW = this.image.getWidth(null);
        int realH = this.image.getHeight(null);
        int w = realW;
        int h = realH;
        double wScale = 1.0;
        double hScale = 1.0;
        boolean bl = isFast = this.isFast || w < this.width || h < this.height;
        if (isFast) {
            thumbnail = this.image.getScaledInstance(this.width, this.height, this.imageQuality);
            path = this.paintBrick(1.0, 1.0);
            w = this.width;
            h = this.height;
        } else {
            boolean flag = false;
            if ((double)realW > (double)this.width * this.maxRatio) {
                w = Math.min((int)((double)this.width * this.maxRatio), realW);
                flag = true;
            }
            if ((double)realH > (double)this.height * this.maxRatio) {
                h = Math.min((int)((double)this.height * this.maxRatio), realH);
                flag = true;
            }
            thumbnail = flag ? this.image.getScaledInstance(w, h, this.imageQuality) : this.image;
            hScale = NumberUtil.div((float)h, (float)this.height);
            wScale = NumberUtil.div((float)w, (float)this.width);
            path = this.paintBrick(wScale, hScale);
        }
        float radius = 5.0f * ((float)w / 280.0f) * (float)wScale;
        int left = 1;
        ShadowFilter shadowFilter = new ShadowFilter(radius, 2.0f * (float)wScale, -1.0f * (float)hScale, 0.8f);
        BufferedImage artwork = this.translucent(new BufferedImage(w, h, 2));
        BufferedImage localVacancy = this.translucent(new BufferedImage(w, h, 2));
        Graphics2D vg = localVacancy.createGraphics();
        vg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        vg.setClip(path);
        vg.drawImage(thumbnail, null, null);
        if (this.vacancyBorderColor != null) {
            vg.setColor(this.vacancyBorderColor);
            vg.setStroke(new BasicStroke(this.vacancyBorderWidth));
            vg.draw(path);
        }
        vg.dispose();
        Graphics2D g = artwork.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(thumbnail, null, null);
        g.setClip(path);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fill(path);
        if (this.artworkBorderColor != null) {
            g.setColor(this.artworkBorderColor);
            g.setStroke(new BasicStroke(this.artworkBorderWidth));
            g.draw(path);
        }
        g.drawImage(shadowFilter.filter(alphaFilter.filter(localVacancy, null), null), null, null);
        g.dispose();
        localVacancy = ImageUtils.getSubimage((BufferedImage)localVacancy, (int)((int)((double)this.x * wScale - (double)left)), (int)0, (int)((int)Math.ceil(path.getBounds().getWidth() + (double)radius) + left), (int)h);
        if (isFast) {
            this.vacancy = shadowFilter.filter(localVacancy, null);
            this.artwork = artwork;
        } else {
            localVacancy = shadowFilter.filter(localVacancy, null);
            this.artwork = artwork.getScaledInstance(this.width, this.height, this.imageQuality);
            this.vacancy = localVacancy.getScaledInstance((int)((path.getBounds().getWidth() + (double)radius) / wScale), this.height, this.imageQuality);
        }
    }

    private GeneralPath paintBrick(double xScale, double yScale) {
        double x = (double)this.x * xScale;
        double y = (double)this.y * yScale;
        double hMoveL = (double)((float)this.vwh / 3.0f) * yScale;
        double wMoveL = (double)((float)this.vwh / 3.0f) * xScale;
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + wMoveL, y);
        path.append(this.arc(x + wMoveL, y - hMoveL / 2.0, wMoveL, hMoveL, 180.0, -180.0), true);
        path.lineTo(x + wMoveL * 3.0, y);
        path.lineTo(x + wMoveL * 3.0, y + hMoveL);
        path.append(this.arc(x + wMoveL * 2.0 + wMoveL / 2.0, y + hMoveL, wMoveL, hMoveL, 90.0, -180.0), true);
        path.lineTo(x + wMoveL * 3.0, y + hMoveL * 3.0);
        path.lineTo(x, y + hMoveL * 3.0);
        path.lineTo(x, y + hMoveL * 2.0);
        path.append(this.arc(x - wMoveL / 2.0, y + hMoveL, wMoveL, hMoveL, -90.0, 180.0), true);
        path.lineTo(x, y);
        path.closePath();
        return path;
    }

    private Arc2D arc(double x, double y, double w, double h, double start, double extent) {
        return new Arc2D.Double(x, y, w, h, start, extent, 0);
    }

    private BufferedImage translucent(BufferedImage bufferedImage) {
        Graphics2D g = bufferedImage.createGraphics();
        bufferedImage = g.getDeviceConfiguration().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        g.dispose();
        return bufferedImage;
    }

    private static int random(int min, int max) {
        return RANDOM.ints(min, max + 1).findFirst().getAsInt();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getVwh() {
        return this.vwh;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getArtwork() {
        return this.artwork;
    }

    public Image getVacancy() {
        return this.vacancy;
    }

    public boolean isFast() {
        return this.isFast;
    }

    public Color getVacancyBorderColor() {
        return this.vacancyBorderColor;
    }

    public float getVacancyBorderWidth() {
        return this.vacancyBorderWidth;
    }

    public Color getArtworkBorderColor() {
        return this.artworkBorderColor;
    }

    public float getArtworkBorderWidth() {
        return this.artworkBorderWidth;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public int getImageQuality() {
        return this.imageQuality;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setVwh(int vwh) {
        this.vwh = vwh;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setArtwork(Image artwork) {
        this.artwork = artwork;
    }

    public void setVacancy(Image vacancy) {
        this.vacancy = vacancy;
    }

    public void setFast(boolean isFast) {
        this.isFast = isFast;
    }

    public void setVacancyBorderColor(Color vacancyBorderColor) {
        this.vacancyBorderColor = vacancyBorderColor;
    }

    public void setVacancyBorderWidth(float vacancyBorderWidth) {
        this.vacancyBorderWidth = vacancyBorderWidth;
    }

    public void setArtworkBorderColor(Color artworkBorderColor) {
        this.artworkBorderColor = artworkBorderColor;
    }

    public void setArtworkBorderWidth(float artworkBorderWidth) {
        this.artworkBorderWidth = artworkBorderWidth;
    }

    public void setMaxRatio(double maxRatio) {
        this.maxRatio = maxRatio;
    }

    public void setImageQuality(int imageQuality) {
        this.imageQuality = imageQuality;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PuzzleCaptcha)) {
            return false;
        }
        PuzzleCaptcha other = (PuzzleCaptcha)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getVwh() != other.getVwh()) {
            return false;
        }
        if (this.isFast() != other.isFast()) {
            return false;
        }
        if (Float.compare(this.getVacancyBorderWidth(), other.getVacancyBorderWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getArtworkBorderWidth(), other.getArtworkBorderWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxRatio(), other.getMaxRatio()) != 0) {
            return false;
        }
        if (this.getImageQuality() != other.getImageQuality()) {
            return false;
        }
        Image this$image = this.getImage();
        Image other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Image this$artwork = this.getArtwork();
        Image other$artwork = other.getArtwork();
        if (this$artwork == null ? other$artwork != null : !this$artwork.equals(other$artwork)) {
            return false;
        }
        Image this$vacancy = this.getVacancy();
        Image other$vacancy = other.getVacancy();
        if (this$vacancy == null ? other$vacancy != null : !this$vacancy.equals(other$vacancy)) {
            return false;
        }
        Color this$vacancyBorderColor = this.getVacancyBorderColor();
        Color other$vacancyBorderColor = other.getVacancyBorderColor();
        if (this$vacancyBorderColor == null ? other$vacancyBorderColor != null : !((Object)this$vacancyBorderColor).equals(other$vacancyBorderColor)) {
            return false;
        }
        Color this$artworkBorderColor = this.getArtworkBorderColor();
        Color other$artworkBorderColor = other.getArtworkBorderColor();
        return !(this$artworkBorderColor == null ? other$artworkBorderColor != null : !((Object)this$artworkBorderColor).equals(other$artworkBorderColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PuzzleCaptcha;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getVwh();
        result = result * 59 + (this.isFast() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getVacancyBorderWidth());
        result = result * 59 + Float.floatToIntBits(this.getArtworkBorderWidth());
        long $maxRatio = Double.doubleToLongBits(this.getMaxRatio());
        result = result * 59 + (int)($maxRatio >>> 32 ^ $maxRatio);
        result = result * 59 + this.getImageQuality();
        Image $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Image $artwork = this.getArtwork();
        result = result * 59 + ($artwork == null ? 43 : $artwork.hashCode());
        Image $vacancy = this.getVacancy();
        result = result * 59 + ($vacancy == null ? 43 : $vacancy.hashCode());
        Color $vacancyBorderColor = this.getVacancyBorderColor();
        result = result * 59 + ($vacancyBorderColor == null ? 43 : ((Object)$vacancyBorderColor).hashCode());
        Color $artworkBorderColor = this.getArtworkBorderColor();
        result = result * 59 + ($artworkBorderColor == null ? 43 : ((Object)$artworkBorderColor).hashCode());
        return result;
    }

    public String toString() {
        return "PuzzleCaptcha(width=" + this.getWidth() + ", height=" + this.getHeight() + ", x=" + this.getX() + ", y=" + this.getY() + ", vwh=" + this.getVwh() + ", image=" + this.getImage() + ", artwork=" + this.getArtwork() + ", vacancy=" + this.getVacancy() + ", isFast=" + this.isFast() + ", vacancyBorderColor=" + this.getVacancyBorderColor() + ", vacancyBorderWidth=" + this.getVacancyBorderWidth() + ", artworkBorderColor=" + this.getArtworkBorderColor() + ", artworkBorderWidth=" + this.getArtworkBorderWidth() + ", maxRatio=" + this.getMaxRatio() + ", imageQuality=" + this.getImageQuality() + ")";
    }
}

