/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.weixinsign.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.weixinsign.local.config.WXAccountProperties;
import com.biz.crm.common.weixinsign.local.config.WXOpenPlatformAccountProperties;
import com.biz.crm.common.weixinsign.sdk.common.enums.WXAuthorizationChangeTypeEnum;
import com.biz.crm.common.weixinsign.sdk.common.utils.AesException;
import com.biz.crm.common.weixinsign.sdk.common.utils.WXBizMsgCrypt;
import com.biz.crm.common.weixinsign.sdk.common.utils.XMLConverUtil;
import com.biz.crm.common.weixinsign.sdk.common.utils.msg.ComponentReceiveXML;
import com.biz.crm.common.weixinsign.sdk.common.utils.msg.EventReceiveXML;
import com.biz.crm.common.weixinsign.sdk.dto.ComponentVerifyTicketDto;
import com.biz.crm.common.weixinsign.sdk.dto.MsgEventDto;
import com.biz.crm.common.weixinsign.sdk.service.WXCacheVoService;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenPlatformVoService;
import com.biz.crm.common.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxCacheVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxComponentAccessTokenRespVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxJsApiTicketRespVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WXOpenPlatformVoServiceImpl
implements WXOpenPlatformVoService {
    private static final Logger log = LoggerFactory.getLogger(WXOpenPlatformVoServiceImpl.class);
    @Autowired
    private WXAccountProperties wxAccountProperties;
    @Autowired
    private WXCacheVoService wxCache;
    @Autowired
    @Qualifier(value="restTemplateRemote")
    private RestTemplate restTemplate;
    @Autowired
    private RedisMutexService redisMutexService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentVerifyTicket(ComponentVerifyTicketDto componentVerifyTicketDto) {
        String signature = componentVerifyTicketDto.getSignature();
        String timestamp = componentVerifyTicketDto.getTimestamp();
        String nonce = componentVerifyTicketDto.getNonce();
        String msgSignature = componentVerifyTicketDto.getMsgSignature();
        String xmlEncrypt = componentVerifyTicketDto.getXmlEncrypt();
        Validate.notNull((Object)this.wxAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u4fe1\u606f", (Object[])new Object[0]);
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentToken = wxOpenPlatformAccountProperties.getComponentToken();
        String componentEncodingaesKey = wxOpenPlatformAccountProperties.getComponentEncodingaesKey();
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        log.debug(String.format("COMPONENT_TOKEN=%s,signature=%s,timestamp=%s,nonce=%s,msgSignature=%s,xml=%s", componentToken, signature, timestamp, nonce, msgSignature, xmlEncrypt));
        if (StringUtils.isBlank((CharSequence)msgSignature)) {
            return;
        }
        boolean isValid = this.checkSignature(componentToken, signature, timestamp, nonce);
        log.debug(String.format("\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u6d88\u606f\u9a8c\u8bc1isValid=%s", isValid));
        if (!isValid) {
            return;
        }
        String xml = null;
        try {
            WXBizMsgCrypt pc = new WXBizMsgCrypt(componentToken, componentEncodingaesKey, componentAppid);
            xml = pc.decryptMsg(msgSignature, timestamp, nonce, xmlEncrypt);
        }
        catch (AesException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5fae\u4fe1xml\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        ComponentReceiveXML com = (ComponentReceiveXML)XMLConverUtil.convertToObject(ComponentReceiveXML.class, (String)xml);
        log.debug("ComponentReceiveXML=" + com.toString());
        String redisKey = String.format("OPEN_CACHE_COMPONENT_VERIFY_TICKET_KEY:%s", com.getAppid());
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u7f13\u5b58componentVerifyTicket\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            if (Objects.equals(com.getInfoType(), "component_verify_ticket")) {
                String cacheKey = String.format("OPEN_CACHE_COMPONENT_VERIFY_TICKET:%s", com.getAppid());
                WxCacheVo cacheVo = new WxCacheVo();
                cacheVo.setCreateTimestamp(new Date().getTime());
                cacheVo.setValue(com.getComponentVerifyTicket());
                cacheVo.setExpiresIn(43200L);
                this.wxCache.set(cacheKey, JSONObject.toJSONString((Object)cacheVo));
            } else if (Objects.equals(com.getInfoType(), WXAuthorizationChangeTypeEnum.AUTHORIZED.getCode())) {
                this.getApiQueryAuth(com.getAuthorizationCode());
            } else if (Objects.equals(com.getInfoType(), WXAuthorizationChangeTypeEnum.UPDATEAUTHORIZED.getCode())) {
                this.getApiQueryAuth(com.getAuthorizationCode());
            } else if (Objects.equals(com.getInfoType(), WXAuthorizationChangeTypeEnum.UNAUTHORIZED.getCode())) {
                String authorizerAccessTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN:%s", com.getAuthorizerAppid());
                String authorizerRefreshTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN:%s", com.getAuthorizerAppid());
                this.wxCache.remove(authorizerAccessTokenCacheKey);
                this.wxCache.remove(authorizerRefreshTokenCacheKey);
            }
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    public EventReceiveXML analyzeMsgEvent(MsgEventDto msgEventDto) {
        String timestamp = msgEventDto.getTimestamp();
        String nonce = msgEventDto.getNonce();
        String msgSignature = msgEventDto.getMsgSignature();
        String signature = msgEventDto.getSignature();
        String xmlEncrypt = msgEventDto.getXmlEncrypt();
        Validate.notNull((Object)this.wxAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u4fe1\u606f", (Object[])new Object[0]);
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentToken = wxOpenPlatformAccountProperties.getComponentToken();
        String componentEncodingaesKey = wxOpenPlatformAccountProperties.getComponentEncodingaesKey();
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        log.debug(String.format("COMPONENT_TOKEN=%s,timestamp=%s,nonce=%s,msgSignature=%s,xml=%s", componentToken, timestamp, nonce, msgSignature, xmlEncrypt));
        if (StringUtils.isBlank((CharSequence)msgSignature)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)signature)) {
            boolean isValid = this.checkSignature(componentToken, signature, timestamp, nonce);
            Validate.isTrue((boolean)isValid, (String)"\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u6d88\u606f\u9a8c\u8bc1\u5931\u8d25", (Object[])new Object[0]);
        }
        String xml = null;
        try {
            WXBizMsgCrypt pc = new WXBizMsgCrypt(componentToken, componentEncodingaesKey, componentAppid);
            xml = pc.decryptMsg(msgSignature, timestamp, nonce, xmlEncrypt);
        }
        catch (AesException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5fae\u4fe1xml\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        EventReceiveXML eventMsg = (EventReceiveXML)XMLConverUtil.convertToObject(EventReceiveXML.class, (String)xml);
        return eventMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComponentAccessToken() {
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        String redisKey = String.format("OPEN_CACHE_COMPONENT_ACCESS_TOKEN_TICKET_KEY:%s", componentAppid);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u7f13\u5b58componentAccessToken\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            String componentAppsecret = wxOpenPlatformAccountProperties.getComponentAppSecret();
            String openCacheKey = String.format("OPEN_CACHE_COMPONENT_ACCESS_TOKEN_TICKET:%s", componentAppid);
            String accessToken = this.wxCache.get(openCacheKey);
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                log.debug("\u7b2c\u4e09\u65b9\u5e73\u53f0componentAccessToken:{}", (Object)accessToken);
                String string = accessToken;
                return string;
            }
            String cacheKey = String.format("OPEN_CACHE_COMPONENT_VERIFY_TICKET:%s", componentAppid);
            String componentVerifyTicket = this.wxCache.get(cacheKey);
            Validate.notBlank((CharSequence)componentVerifyTicket, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0component_access_token\u65f6:componentVerifyTicket\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            JSONObject postData = new JSONObject();
            postData.put("component_appid", (Object)componentAppid);
            postData.put("component_appsecret", (Object)componentAppsecret);
            postData.put("component_verify_ticket", (Object)componentVerifyTicket);
            HttpEntity request = new HttpEntity((Object)postData.toJSONString(), (MultiValueMap)headers);
            WxComponentAccessTokenRespVo componentAccessTokenRespVo = (WxComponentAccessTokenRespVo)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/component/api_component_token", (Object)request, WxComponentAccessTokenRespVo.class, new Object[0]);
            if (Objects.isNull(componentAccessTokenRespVo) || StringUtils.isNotBlank((CharSequence)componentAccessTokenRespVo.getErrcode())) {
                log.warn("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0componentAccessToken\u5931\u8d25\uff01{}", (Object)componentAccessTokenRespVo.getErrmsg());
                String string = null;
                return string;
            }
            accessToken = componentAccessTokenRespVo.getComponentAccessToken();
            WxCacheVo cacheVo = new WxCacheVo();
            cacheVo.setCreateTimestamp(new Date().getTime());
            cacheVo.setValue(accessToken);
            cacheVo.setExpiresIn(componentAccessTokenRespVo.getExpiresIn());
            this.wxCache.set(openCacheKey, JSONObject.toJSONString((Object)cacheVo));
            log.debug("\u7b2c\u4e09\u65b9\u5e73\u53f0componentAccessToken:{}", (Object)accessToken);
            String string = accessToken;
            return string;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApiQueryAuth(String authorizationCode) {
        String redisKey = String.format("OPEN_COMPONENT_ACCESS_AUTHORIZATION_CODE_KEY", authorizationCode);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u7f13\u5b58ApiQueryAuth\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
            Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
            String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
            String componentAccessToken = this.getComponentAccessToken();
            Validate.notBlank((CharSequence)componentAccessToken, (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0ApiQueryAuth\u65f6:componentAccessToken\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            JSONObject postData = new JSONObject();
            postData.put("component_appid", (Object)componentAppid);
            postData.put("authorization_code", (Object)authorizationCode);
            HttpEntity request = new HttpEntity((Object)postData.toJSONString(), (MultiValueMap)headers);
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("component_access_token", componentAccessToken);
            JSONObject apiQueryAuthRespVo = (JSONObject)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/component/api_query_auth?component_access_token={component_access_token}", (Object)request, JSONObject.class, uriVariables);
            if (Objects.isNull(apiQueryAuthRespVo) || StringUtils.isNotBlank((CharSequence)apiQueryAuthRespVo.getString("errcode"))) {
                log.warn("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0apiQueryAuth\u5931\u8d25\uff01{}", (Object)apiQueryAuthRespVo.getString("errmsg"));
                String string = null;
                return string;
            }
            JSONObject authorizationInfoJson = apiQueryAuthRespVo.getJSONObject("authorization_info");
            String authorizerAppid = authorizationInfoJson.getString("authorizer_appid");
            String authorizerAccessToken = authorizationInfoJson.getString("authorizer_access_token");
            String authorizerRefreshToken = authorizationInfoJson.getString("authorizer_refresh_token");
            String authorizerAccessTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN:%s", authorizerAppid);
            int expires_in = authorizationInfoJson.getIntValue("expires_in");
            WxCacheVo authorizerAccessTokenCacheVo = new WxCacheVo();
            authorizerAccessTokenCacheVo.setCreateTimestamp(new Date().getTime());
            authorizerAccessTokenCacheVo.setValue(authorizerAccessToken);
            authorizerAccessTokenCacheVo.setExpiresIn((long)expires_in);
            this.wxCache.set(authorizerAccessTokenCacheKey, JSONObject.toJSONString((Object)authorizerAccessTokenCacheVo));
            String authorizerRefreshTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN:%s", authorizerAppid);
            WxCacheVo authorizerRefreshTokenCacheVo = new WxCacheVo();
            authorizerRefreshTokenCacheVo.setCreateTimestamp(new Date().getTime());
            authorizerRefreshTokenCacheVo.setValue(authorizerRefreshToken);
            authorizerRefreshTokenCacheVo.setExpiresIn(2592000L);
            this.wxCache.set(authorizerRefreshTokenCacheKey, JSONObject.toJSONString((Object)authorizerRefreshTokenCacheVo));
            log.debug("\u7b2c\u4e09\u65b9\u5e73\u53f0authorizerAccessToken:{}", (Object)authorizerAccessToken);
            String string = authorizerAccessToken;
            return string;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    public String customSendMessage(JSONObject message, String authorizerAccessToken) {
        if (Objects.isNull(message) || StringUtils.isBlank((CharSequence)authorizerAccessToken)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)message.toJSONString(), (MultiValueMap)headers);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("access_token", authorizerAccessToken);
        JSONObject msgRespVo = (JSONObject)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={access_token}", (Object)request, JSONObject.class, uriVariables);
        if (Objects.isNull(msgRespVo) || StringUtils.isNotBlank((CharSequence)msgRespVo.getString("errcode"))) {
            log.warn("\u53d1\u9001\u5ba2\u670d\u6d88\u606f\u5931\u8d25\uff01{}", (Object)msgRespVo.getString("errmsg"));
            return null;
        }
        return msgRespVo.toJSONString();
    }

    public String getPreAuthCode() {
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        String componentAccessToken = this.getComponentAccessToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject postData = new JSONObject();
        postData.put("component_appid", (Object)componentAppid);
        HttpEntity request = new HttpEntity((Object)postData.toJSONString(), (MultiValueMap)headers);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("component_access_token", componentAccessToken);
        JSONObject msgRespVo = (JSONObject)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token={component_access_token}", (Object)request, JSONObject.class, uriVariables);
        if (Objects.isNull(msgRespVo) || StringUtils.isNotBlank((CharSequence)msgRespVo.getString("errcode"))) {
            log.warn("\u53d1\u9001\u5ba2\u670d\u6d88\u606f\u5931\u8d25\uff01{}", (Object)msgRespVo.getString("errmsg"));
            return null;
        }
        return msgRespVo.getString("pre_auth_code");
    }

    public String getComponentAuthUrl(String redirectUri) {
        String preAuthCode = this.getPreAuthCode();
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        String url = String.format("https://mp.weixin.qq.com/cgi-bin/componentloginpage?component_appid=%s&pre_auth_code=%s&redirect_uri=%s&auth_type=%s", componentAppid, preAuthCode, redirectUri, 1);
        return url;
    }

    public String getAuthorizeUrl(String redirectUri, String scope, String appid) {
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        String urlEncodeRedirectUri = null;
        try {
            urlEncodeRedirectUri = URLEncoder.encode(redirectUri, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("redirectUri\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String authorizeUrl = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=123&component_appid=%s#wechat_redirect", appid, urlEncodeRedirectUri, scope, componentAppid);
        return authorizeUrl;
    }

    public WxWebViewAccessTokenRespVo findWebViewAccessToken(String code, String appid) {
        WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
        Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
        String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
        if (StringUtils.isBlank((CharSequence)code)) {
            log.warn("\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\u5931\u8d25!code\u4e3a\u7a7a");
            return null;
        }
        String componentAccessToken = this.getComponentAccessToken();
        Validate.notBlank((CharSequence)"componentAccessToken", (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0accesstoken\u5931\u8d25", (Object[])new Object[0]);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("appid", appid);
        uriVariables.put("component_appid", componentAppid);
        uriVariables.put("component_access_token", componentAccessToken);
        uriVariables.put("code", code);
        String jsonStr = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/sns/oauth2/component/access_token?appid={appid}&code={code}&grant_type=authorization_code&component_appid={component_appid}&component_access_token={component_access_token}", String.class, uriVariables);
        WxWebViewAccessTokenRespVo accessTokenRespVo = (WxWebViewAccessTokenRespVo)JSONObject.parseObject((String)jsonStr, WxWebViewAccessTokenRespVo.class);
        if (Objects.isNull(accessTokenRespVo) || StringUtils.isNotBlank((CharSequence)accessTokenRespVo.getErrcode())) {
            log.warn("\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\u5931\u8d25\uff01{}", (Object)accessTokenRespVo.getErrmsg());
            return null;
        }
        log.info("\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\uff01{}", (Object)JSONObject.toJSONString((Object)accessTokenRespVo));
        return accessTokenRespVo;
    }

    public WXJsConfigVo findWXJsConfig(String url, String appid) {
        Validate.notBlank((CharSequence)url, (String)"\u83b7\u53d6jssdk\u7684url\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String jsapiTicket = this.findJsApiTicket(appid);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            return null;
        }
        String nonceStr = UUID.randomUUID().toString();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signOriginal = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", jsapiTicket, nonceStr, timestamp, url);
        log.info("wxopen:signOriginal:{}", (Object)signOriginal);
        String signature = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(signOriginal.getBytes("UTF-8"));
            signature = this.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Validate.notBlank(signature, (String)"\u83b7\u53d6jssdk\u65f6\u7b7e\u540d\u5931\u8d25", (Object[])new Object[0]);
        WXJsConfigVo vo = new WXJsConfigVo();
        vo.setAppId(appid);
        vo.setNonceStr(nonceStr);
        vo.setSignature(signature);
        vo.setTimestamp(timestamp);
        return vo;
    }

    public String findJsApiTicket(String appid) {
        log.info("wxopen:jsApiTicket:wxProperties:{}", (Object)appid);
        String cacheKey = String.format("OPEN_CACHE_JSAPI_TICKET:%s", appid);
        String jsApiTicket = this.wxCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)jsApiTicket)) {
            log.debug("wxopen:jsApiTicket:{}", (Object)jsApiTicket);
            return jsApiTicket;
        }
        String accessToken = this.findApiAuthorizerToken(appid);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("access_token", accessToken);
        uriVariables.put("type", "jsapi");
        WxJsApiTicketRespVo jsApiTicketRespVo = (WxJsApiTicketRespVo)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={access_token}&type={type}", WxJsApiTicketRespVo.class, uriVariables);
        if (Objects.isNull(jsApiTicketRespVo) || !Objects.equals(jsApiTicketRespVo.getErrcode(), "0")) {
            log.warn("wxopen:\u83b7\u53d6\u5fae\u4fe1\u5168\u5c40JSAPI_TICKET\u5931\u8d25\uff01{}", (Object)jsApiTicketRespVo.getErrmsg());
            return null;
        }
        jsApiTicket = jsApiTicketRespVo.getTicket();
        WxCacheVo cacheVo = new WxCacheVo();
        cacheVo.setCreateTimestamp(new Date().getTime());
        cacheVo.setValue(jsApiTicket);
        cacheVo.setExpiresIn(jsApiTicketRespVo.getExpiresIn());
        this.wxCache.set(cacheKey, JSONObject.toJSONString((Object)cacheVo));
        log.debug("wxopen:jsApiTicket:{}", (Object)jsApiTicket);
        return jsApiTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findApiAuthorizerToken(String appid) {
        log.info("wxopen:jsApiTicket:wxProperties:{}", (Object)appid);
        String redisKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN_KEY_FORMAT", appid);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u7f13\u5b58ApiAuthorizerToken\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            String authorizerAccessTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_ACCESS_TOKEN:%s", appid);
            String authorizerAccessToken = this.wxCache.get(authorizerAccessTokenCacheKey);
            if (StringUtils.isNotBlank((CharSequence)authorizerAccessToken)) {
                log.debug("wxopen:authorizer_access_token:{}", (Object)authorizerAccessToken);
                String string = authorizerAccessToken;
                return string;
            }
            WXOpenPlatformAccountProperties wxOpenPlatformAccountProperties = this.wxAccountProperties.getOpenPlatformAccount();
            Validate.notNull((Object)wxOpenPlatformAccountProperties, (String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f", (Object[])new Object[0]);
            String componentAppid = wxOpenPlatformAccountProperties.getComponentAppid();
            String authorizerRefreshTokenCacheKey = String.format("OPEN_CACHE_COMPONENT_AUTHORIZER_REFRESH_TOKEN:%s", appid);
            String authorizerRefreshToken = this.wxCache.get(authorizerRefreshTokenCacheKey);
            Validate.notBlank((CharSequence)"authorizerRefreshToken", (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0authorizerRefreshToken\u5931\u8d25,\u8bf7\u5148\u6388\u6743\uff0c\u6216\u8005\u91cd\u65b0\u6388\u6743", (Object[])new Object[0]);
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            String accessToken = this.getComponentAccessToken();
            Validate.notBlank((CharSequence)"componentAccessToken", (String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0accesstoken\u5931\u8d25", (Object[])new Object[0]);
            uriVariables.put("component_access_token", accessToken);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            JSONObject postData = new JSONObject();
            postData.put("component_appid", (Object)componentAppid);
            postData.put("authorizer_appid", (Object)appid);
            postData.put("authorizer_refresh_token", (Object)authorizerRefreshToken);
            HttpEntity request = new HttpEntity((Object)postData.toJSONString(), (MultiValueMap)headers);
            JSONObject respVo = (JSONObject)this.restTemplate.postForObject("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token={component_access_token}", (Object)request, JSONObject.class, uriVariables);
            if (Objects.isNull(respVo) || StringUtils.isNotBlank((CharSequence)respVo.getString("errcode"))) {
                log.warn("wxopen:\u83b7\u53d6\u5fae\u4fe1\u5168\u5c40authorizer_access_token\u5931\u8d25\uff01{}", (Object)respVo.getString("errmsg"));
                String string = null;
                return string;
            }
            authorizerAccessToken = respVo.getString("authorizer_access_token");
            authorizerRefreshToken = respVo.getString("authorizer_refresh_token");
            int expires_in = respVo.getIntValue("expires_in");
            WxCacheVo authorizerAccessTokenCacheVo = new WxCacheVo();
            authorizerAccessTokenCacheVo.setCreateTimestamp(new Date().getTime());
            authorizerAccessTokenCacheVo.setValue(authorizerAccessToken);
            authorizerAccessTokenCacheVo.setExpiresIn((long)expires_in);
            this.wxCache.set(authorizerAccessTokenCacheKey, JSONObject.toJSONString((Object)authorizerAccessTokenCacheVo));
            WxCacheVo authorizerRefreshTokenCacheVo = new WxCacheVo();
            authorizerRefreshTokenCacheVo.setCreateTimestamp(new Date().getTime());
            authorizerRefreshTokenCacheVo.setValue(authorizerRefreshToken);
            authorizerRefreshTokenCacheVo.setExpiresIn(2592000L);
            this.wxCache.set(authorizerRefreshTokenCacheKey, JSONObject.toJSONString((Object)authorizerRefreshTokenCacheVo));
            log.debug("\u7b2c\u4e09\u65b9\u5e73\u53f0authorizerAccessToken:{}", (Object)authorizerAccessToken);
            String string = authorizerAccessToken;
            return string;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    private boolean checkSignature(String componentToken, String signature, String timestamp, String nonce) {
        boolean flag = false;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce})) {
            return flag;
        }
        String signatureValue = "";
        Object[] arr = new String[]{componentToken, timestamp, nonce};
        Arrays.sort(arr);
        for (Object temp : arr) {
            signatureValue = signatureValue + (String)temp;
        }
        String signatureVerify = null;
        try {
            signatureVerify = DigestUtils.shaHex((String)signatureValue);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (signature.equals(signatureVerify)) {
            flag = true;
        }
        return flag;
    }

    private String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

