package com.biz.crm.common.weixinsign.local.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.weixinsign.sdk.vo.OpenIdVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月30日 10:46:00
 */
@Slf4j
@Configuration
public class WxAppletConfigTest {
  @Value("${weixing.dms.appID}")
  private String appId;
  @Value("${weixing.dms.appSecret}")
  private String appSecret;

  private String interfaceUtil(String path, String data) {
    String returnJson = "";
    InputStream is = null;
    HttpURLConnection conn = null;
    try {
      URL url = new URL(path);
      //打开和url之间的连接
      conn = (HttpURLConnection) url.openConnection();
      PrintWriter out = null;
      //请求方式
//          conn.setRequestMethod("POST");
//           //设置通用的请求属性
      conn.setRequestProperty("accept", "*/*");
      conn.setRequestProperty("connection", "Keep-Alive");
      conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
      //设置是否向httpUrlConnection输出，设置是否从httpUrlConnection读入，此外发送post请求必须设置这两个
      //最常用的Http请求无非是get和post，get请求可以获取静态页面，也可以把参数放在URL字串后面，传递给servlet，
      //post与get的 不同之处在于post的参数不是放在URL字串里面，而是放在http请求的正文内。
      conn.setDoOutput(true);
      conn.setDoInput(true);
      //获取URLConnection对象对应的输出流
      out = new PrintWriter(conn.getOutputStream());
      //发送请求参数即数据
      out.print(data);
      //缓冲数据
      out.flush();
      //获取URLConnection对象对应的输入流
      is = conn.getInputStream();
      //构造一个字符流缓存
      BufferedReader br = new BufferedReader(new InputStreamReader(is));
      String str = "";
      while ((str = br.readLine()) != null) {
        returnJson = str;
      }
      //关闭流
      is.close();
      //断开连接，最好写上，disconnect是在底层tcp socket链接空闲时才切断。如果正在被其他线程使用就不切断。
      //固定多线程的话，如果不disconnect，链接会增多，直到收发不出信息。写上disconnect后正常一些。
      conn.disconnect();
    } catch (Exception e) {
      log.error("获取openid异常", e);
      try {
        if (is != null) {
          is.close();
        }
        if (conn != null) {
          conn.disconnect();
        }
      } catch (Exception e1) {
        log.error("获取openid异常", e1);
      }
    }
    return returnJson;
  }

  /**
   * 获取openId
   * ozhnw0EW-q3DrLrofAL-G0ruElro * @param code
   *
   * @return
   */
  public OpenIdVo getAppletOpenId(String code) {
    if (StringUtils.isAnyBlank(appId, appSecret)) {
      throw new RuntimeException("未配置微信 appId 或者 appSecret ");
    }
    String URL = "https://api.weixin.qq.com/sns/jscode2session?appid=" + appId + "&secret=" + appSecret + "&js_code=" + code + "&grant_type=authorization_code";
    String returnJson = interfaceUtil(URL, "");
    if (StringUtils.isEmpty(returnJson)) {
      return null;
    }
    log.info("获取微信登录openId等信息:  " + returnJson);
    String session_key = JSON.parseObject(returnJson).getString("session_key");
    try {
      session_key = java.net.URLEncoder.encode(session_key, StandardCharsets.UTF_8.name());
    } catch (Exception e) {
      log.error("获取openid异常", e);
      throw new RuntimeException("获取openid异常", e);
    }
    OpenIdVo openIdVo = JsonUtils.json2Obj(returnJson, OpenIdVo.class);
    openIdVo.setSession_key(session_key);
    log.info("获取微信登录session_key信息:  " + session_key);
    return openIdVo;
  }
}
