/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.weixinsign.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.weixinsign.local.config.WxAppletConfigTest;
import com.biz.crm.common.weixinsign.local.controller.WxBaseController;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.common.weixinsign.sdk.vo.OpenIdVo;
import com.biz.crm.common.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/wx/wxOpen"})
@Api(tags={"\u5fae\u4fe1http\u63a5\u53e3"})
public class WXOpenController
extends WxBaseController {
    private static final Logger log = LoggerFactory.getLogger(WXOpenController.class);
    @Autowired
    private WXOpenVoService wxOpenService;
    @Autowired
    private WxAppletConfigTest wxAppletConfigTest;

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40jssdk\u914d\u7f6e")
    @GetMapping(value={"/findWXJsConfig"})
    public Result<WXJsConfigVo> findWXJsConfig(@ApiParam(value="\u7b7e\u540durl") String url, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType, @RequestParam(required=false) Boolean isUrlEncoder) {
        try {
            if (Objects.nonNull(isUrlEncoder) && isUrlEncoder.booleanValue() && StringUtils.isNotBlank((CharSequence)url)) {
                try {
                    url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            WXJsConfigVo value = this.wxOpenService.findWXJsConfig(url, appType);
            return Result.ok((Object)value);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40token\u914d\u7f6e")
    @GetMapping(value={"/findAccessTokenByAppType"})
    public Result<String> findAccessTokenByAppType(@RequestParam(required=false) @ApiParam(value="\u5e94\u7528\u7c7b\u578b") String appType) {
        try {
            String value = this.wxOpenService.findAccessToken(appType);
            Result result = Result.ok((String)"");
            result.setResult((Object)value);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6JsApiTicket\u914d\u7f6e")
    @GetMapping(value={"/findJsApiTicketByAppType"})
    public Result<String> findJsApiTicketByAppType(@RequestParam(required=false) @ApiParam(value="\u5e94\u7528\u7c7b\u578b") String appType) {
        try {
            String value = this.wxOpenService.findJsApiTicket(appType);
            Result result = Result.ok((String)"");
            result.setResult((Object)value);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743accessToken")
    @GetMapping(value={"/findWebViewAccessToken"})
    public Result<WxWebViewAccessTokenRespVo> findWebViewAccessToken(@ApiParam(value="code") @RequestParam String code, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) String appType) {
        try {
            WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenService.findWebViewAccessToken(code, appType);
            return Result.ok((Object)accessTokenRespVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7checkCode\u83b7\u53d6openid")
    @GetMapping(value={"findByCheckCode"})
    public Result<OpenIdVo> findByCheckCode(@ApiParam(name="checkCode", value="\u51ed\u8bc1") String checkCode) {
        try {
            if (StringUtils.isBlank((CharSequence)checkCode)) {
                return Result.ok((Object)new OpenIdVo());
            }
            OpenIdVo appletOpenId = this.wxAppletConfigTest.getAppletOpenId(checkCode);
            return Result.ok((Object)appletOpenId);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

