/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.weixinsign.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.weixinsign.local.config.WXAccountProperties;
import com.biz.crm.common.weixinsign.local.controller.WxBaseController;
import com.biz.crm.common.weixinsign.sdk.common.enums.WXMsgTypeEnum;
import com.biz.crm.common.weixinsign.sdk.common.utils.XMLConverUtil;
import com.biz.crm.common.weixinsign.sdk.common.utils.msg.EventReceiveXML;
import com.biz.crm.common.weixinsign.sdk.common.utils.msg.TextMsgReplyXML;
import com.biz.crm.common.weixinsign.sdk.dto.ComponentVerifyTicketDto;
import com.biz.crm.common.weixinsign.sdk.dto.MsgEventDto;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenPlatformVoService;
import com.biz.crm.common.weixinsign.sdk.vo.WXJsConfigVo;
import com.biz.crm.common.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0 controller")
@RestController
@RequestMapping(value={"/v1/wx/open"})
public class WXChatOpenPlatformController
extends WxBaseController {
    private static final Logger log = LoggerFactory.getLogger(WXChatOpenPlatformController.class);
    @Autowired
    private WXOpenPlatformVoService wxOpenPlatformService;
    @Autowired
    private WXAccountProperties wxAccountProperties;

    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40jssdk\u914d\u7f6e")
    @GetMapping(value={"/{appid}/findWXJsConfig"})
    public Result<WXJsConfigVo> findWXJsConfig(@ApiParam(value="\u7b7e\u540durl") String url, @PathVariable(value="appid") String appid, @RequestParam(required=false) Boolean isUrlEncoder) {
        try {
            if (Objects.nonNull(isUrlEncoder) && isUrlEncoder.booleanValue() && StringUtils.isNotBlank((CharSequence)url)) {
                try {
                    url = URLDecoder.decode(url, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            WXJsConfigVo value = this.wxOpenPlatformService.findWXJsConfig(url, appid);
            return Result.ok((Object)value);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743accessToken")
    @GetMapping(value={"/{appid}/findWebViewAccessToken"})
    public Result<WxWebViewAccessTokenRespVo> findWebViewAccessToken(@RequestParam(required=true) String code, @PathVariable(value="appid") String appid) {
        try {
            WxWebViewAccessTokenRespVo accessTokenRespVo = this.wxOpenPlatformService.findWebViewAccessToken(code, appid);
            return Result.ok((Object)accessTokenRespVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/sysMsg"})
    public void sysMsg(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="msg_signature") String msgSignature, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader in = request.getReader();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        String xml = sb.toString();
        ComponentVerifyTicketDto dto = new ComponentVerifyTicketDto();
        dto.setMsgSignature(msgSignature);
        dto.setNonce(nonce);
        dto.setTimestamp(timestamp);
        dto.setSignature(signature);
        dto.setXmlEncrypt(xml);
        this.wxOpenPlatformService.componentVerifyTicket(dto);
        PrintWriter pw = response.getWriter();
        pw.write("success");
        pw.flush();
        response.reset();
    }

    @ResponseBody
    @RequestMapping(value={"{appid}/event"}, method={RequestMethod.POST})
    public void event(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="appid") String appId) throws IOException {
        String line;
        String nonce = request.getParameter("nonce");
        String timestamp = request.getParameter("timestamp");
        String msgSignature = request.getParameter("msg_signature");
        String signature = request.getParameter("signature");
        StringBuilder sb = new StringBuilder();
        BufferedReader in = request.getReader();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        String xml = sb.toString();
        MsgEventDto dto = new MsgEventDto();
        dto.setMsgSignature(msgSignature);
        dto.setNonce(nonce);
        dto.setTimestamp(timestamp);
        dto.setSignature(signature);
        dto.setXmlEncrypt(xml);
        EventReceiveXML eventMsg = this.wxOpenPlatformService.analyzeMsgEvent(dto);
        if (Objects.isNull(eventMsg)) {
            return;
        }
        String msgType = eventMsg.getMsgType();
        String toUserName = eventMsg.getToUserName();
        String fromUserName = eventMsg.getFromUserName();
        String event = eventMsg.getEvent();
        String content = eventMsg.getContent();
        List<String> testAppid = this.wxAccountProperties.getOpenPlatformAccount().getTestAppidUsername();
        if (testAppid.contains(appId)) {
            this.testAppidEvent(request, response, eventMsg, appId);
        }
    }

    private void testAppidEvent(HttpServletRequest request, HttpServletResponse response, EventReceiveXML eventMsg, String appid) {
        log.info("\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u81ea\u52a8\u5316\u6d4b\u8bd5\u9a8c\u8bc1\u6d88\u606f\u5f00\u59cb\u3002\u3002\u3002\u3002");
        String msgType = eventMsg.getMsgType();
        String toUserName = eventMsg.getToUserName();
        String fromUserName = eventMsg.getFromUserName();
        String event = eventMsg.getEvent();
        String content = eventMsg.getContent();
        if (Objects.equals(WXMsgTypeEnum.EVENT.getCode(), msgType)) {
            this.replyEventMessage(request, response, event, fromUserName, toUserName);
        }
        if (Objects.equals(WXMsgTypeEnum.TEXT.getCode(), msgType)) {
            this.processTextMessage(request, response, content, fromUserName, toUserName, appid);
        }
    }

    private void replyEventMessage(HttpServletRequest request, HttpServletResponse response, String event, String toUserName, String fromUserName) {
        String content = event + "from_callback";
        this.replyTextMessage(request, response, content, toUserName, fromUserName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTextMessage(HttpServletRequest request, HttpServletResponse response, String content, String toUserName, String fromUserName, String appid) {
        if ("TESTCOMPONENT_MSG_TYPE_TEXT".equals(content)) {
            String returnContent = content + "_callback";
            this.replyTextMessage(request, response, returnContent, toUserName, fromUserName);
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)content, (CharSequence)"QUERY_AUTH_CODE")) {
            try {
                response.getWriter().print("");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                response.reset();
            }
            log.info("content:" + content + " content[1]:" + content.split(":")[1] + " fromUserName:" + fromUserName + " toUserName:" + toUserName);
            this.replyApiTextMessage(content.split(":")[1], toUserName, appid);
        }
    }

    private void replyTextMessage(HttpServletRequest request, HttpServletResponse response, String content, String toUserName, String fromUserName) {
        Long createTime = System.currentTimeMillis() / 1000L;
        TextMsgReplyXML xmlObj = new TextMsgReplyXML(toUserName, fromUserName, createTime, WXMsgTypeEnum.TEXT.getCode(), content);
        String replyMsg = XMLConverUtil.convertToXML((Object)xmlObj);
        log.info("\u786e\u5b9a\u53d1\u9001\u7684XML\u4e3a\uff1a" + replyMsg);
        this.returnJSON(replyMsg, response);
    }

    private void replyApiTextMessage(String auth_code, String fromUserName, String appid) {
        String authorizerAccessToken = this.wxOpenPlatformService.getApiQueryAuth(auth_code);
        JSONObject message = new JSONObject();
        message.put("touser", (Object)fromUserName);
        message.put("msgtype", (Object)"text");
        JSONObject text = new JSONObject();
        text.put("content", (Object)(auth_code + "_from_api"));
        message.put("text", (Object)text);
        String result = this.wxOpenPlatformService.customSendMessage(message, authorizerAccessToken);
        log.info("\u5ba2\u670d\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u503c:" + result);
    }

    private void returnJSON(Object data, HttpServletResponse response) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            response.setContentType("application/json");
            JsonGenerator generator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            objectMapper.writeValue(generator, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

