package com.biz.crm.common.weixinsign.local.service.internal;

import com.biz.crm.common.weixinsign.local.config.WXOpenPlatformAccountProperties;
import com.biz.crm.common.weixinsign.local.service.WXOpenPlatformTaskService;
import com.biz.crm.common.weixinsign.local.config.WXAccountProperties;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenPlatformVoService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 第三方平台刷新任务
 * @date 2021/10/18 下午2:00
 */
@Service
public class WXOpenPlatformTaskServiceImpl implements WXOpenPlatformTaskService {

  @Autowired
  private WXAccountProperties wxAccountProperties;
  @Autowired
  private WXOpenPlatformVoService wxOpenPlatformService;

  @Override
  @DynamicTaskService(cornExpression = "0 0 0 1 * ?", taskDesc = "每日刷新ApiAuthorizerToken任务")
  public void refreshApiAuthorizerToken() {
    WXOpenPlatformAccountProperties openPlatformAccount = wxAccountProperties.getOpenPlatformAccount();
    if (Objects.isNull(openPlatformAccount)) {
      return;
    }
    List<String> authorizedAppids = openPlatformAccount.getAuthorizedAppids();
    if (CollectionUtils.isEmpty(authorizedAppids)) {
      return;
    }
    authorizedAppids.stream().forEach(appid -> {
      this.wxOpenPlatformService.findApiAuthorizerToken(appid);
    });
  }
}
