/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.weixinsign.local.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.weixinsign.sdk.vo.OpenIdVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxAppletConfigTest {
    private static final Logger log = LoggerFactory.getLogger(WxAppletConfigTest.class);
    @Value(value="${weixing.dms.appID:}")
    private String appId;
    @Value(value="${weixing.dms.appSecret:}")
    private String appSecret;

    private String interfaceUtil(String path, String data) {
        String returnJson = "";
        InputStream is = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            PrintWriter out = null;
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(data);
            out.flush();
            is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = "";
            while ((str = br.readLine()) != null) {
                returnJson = str;
            }
            is.close();
            conn.disconnect();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e);
            try {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e1) {
                log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e1);
            }
        }
        return returnJson;
    }

    public OpenIdVo getAppletOpenId(String code) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.appId, this.appSecret})) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5fae\u4fe1 appId \u6216\u8005 appSecret ");
        }
        String URL2 = "https://api.weixin.qq.com/sns/jscode2session?appid=" + this.appId + "&secret=" + this.appSecret + "&js_code=" + code + "&grant_type=authorization_code";
        String returnJson = this.interfaceUtil(URL2, "");
        if (StringUtils.isEmpty((CharSequence)returnJson)) {
            return null;
        }
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55openId\u7b49\u4fe1\u606f:  " + returnJson);
        String session_key = JSON.parseObject((String)returnJson).getString("session_key");
        try {
            session_key = URLEncoder.encode(session_key, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6openid\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6openid\u5f02\u5e38", e);
        }
        OpenIdVo openIdVo = (OpenIdVo)JsonUtils.json2Obj((String)returnJson, OpenIdVo.class);
        openIdVo.setSession_key(session_key);
        log.info("\u83b7\u53d6\u5fae\u4fe1\u767b\u5f55session_key\u4fe1\u606f:  " + session_key);
        return openIdVo;
    }
}

