package com.biz.crm.common.weixinsign.sdk.common.utils.msg;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Data;

/**
 * 解析完成的推送 事件消息 XML 数据
 *
 * @author hc
 */
@Data
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class EventReceiveXML {

  /**
   * 即接收者）为公众号/小程序原始 ID
   */
  @XmlElement(name = "ToUserName")
  private String toUserName;
  /**
   * 开发者微信号
   */
  @XmlElement(name = "FromUserName")
  private String fromUserName;
  /**
   * 消息创建时间 （整型）
   */
  @XmlElement(name = "CreateTime")
  private Integer createTime;
  /**
   * 消息类型 {@see com.biz.crm.common.weixinsign.sdk.common.enums.WXMsgTypeEnum}
   */
  @XmlElement(name = "MsgType")
  private String msgType;
  /**
   * 事件类型 ，subscribe(订阅)、unsubscribe(取消订阅)
   */
  @XmlElement(name = "Event")
  private String event;
  /**
   * 文本消息内容
   */
  @XmlElement(name = "Content")
  private String content;
}
