package com.biz.crm.common.weixinsign.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 第三方平台验证 Dto
 * @date 2021/10/16 上午10:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ComponentVerifyTicketDto", description = "第三方平台验证 Dto")
public class ComponentVerifyTicketDto {

  /**
   * 签名
   */
  @ApiModelProperty("签名")
  private String signature;
  /**
   * 时间戳
   */
  @ApiModelProperty("时间戳 ")
  private String timestamp;
  /**
   * 获取到的凭证
   */
  @ApiModelProperty("获取到的凭证")
  private String nonce;
  /**
   * 消息体签名，用于验证消息体的正确性
   */
  @ApiModelProperty("获取到的凭证")
  private String msgSignature;
  /**
   * 加密的xml
   */
  @ApiModelProperty("加密的xml")
  private String xmlEncrypt;

}
