package com.biz.crm.common.weixinsign.sdk.service;

/**
 * 微信 缓存
 *
 * @author hecheng
 */
public interface WXCacheVoService {

  /**
   * 获取缓存
   *
   * @param key
   * @return
   */
  String get(String key);

  /**
   * 缓存key 值为jsonValue
   *
   * @param key
   * @param jsonValue
   */
  void set(String key, String jsonValue);

  /**
   * 缓存key 值为jsonValue 有效期为expiresIn 秒
   *
   * @param key
   * @param jsonValue
   * @param expiresIn
   */
  void set(String key, String jsonValue, long expiresIn);

  /**
   * 删除
   *
   * @param key
   */
  void remove(String key);
}
