package com.biz.crm.common.weixinsign.sdk.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: 微信公众号 token vo
 * @date 2021/9/8 下午3:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "WxAccessTokenRespVo", description = "微信公众号 token vo")
public class WxAccessTokenRespVo extends WXErrVo {

  /**
   * 获取到的凭证
   */
  @ApiModelProperty("获取到的凭证")
  @JsonProperty("access_token")
  private String accessToken;
  /**
   * 凭证有效时间，单位：秒s
   */
  @ApiModelProperty("凭证有效时间，单位：秒")
  @JsonProperty("expires_in")
  private long expiresIn;
  /**
   * 创建时间搓
   */
  private long createTimestamp;
}
