package com.biz.crm.cpcnpay.common.security;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.*;
import cfca.sadk.x509.certificate.X509Cert;
import com.biz.crm.cpcnpay.common.utils.DgEnvUtils;
import com.biz.crm.cpcnpay.common.utils.PayUtils;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

/**
 * 国密加密
 *
 * @author Keller
 */
public class SMSigner implements Signer{

  private PrivateKey privateKey;

  private X509Cert x509Cert;

  private static final Mechanism mechanism = new Mechanism("SM2");

  private static Session session;

  public SMSigner(String filename, String password) throws Exception {
    this(filename, password, null);
  }

  public SMSigner(String filename, String password, String serviceID) throws Exception {
    this.x509Cert = CertUtil.getCertFromSM2(filename);
    this.privateKey = (PrivateKey) KeyUtil.getPrivateKeyFromSM2(filename, password);
    JCrypto.getInstance().initialize("JSOFT_LIB", null);
    session = JCrypto.getInstance().openSession("JSOFT_LIB");
  }

  @Override
  public String sign(String message) throws Exception {
    return PayUtils.bytes2hex(sign(message.getBytes()));
  }

  @Override
  public byte[] sign(byte[] data, String algorithm) throws Exception {
    return sign(data);
  }

  @Override
  public byte[] sign(byte[] data) throws Exception {
    Signature signature = new Signature();
    return Base64.decode(signature.p7SignMessageDetach("sm3WithSM2Encryption", data, this.privateKey, this.x509Cert, session));
  }

  @Override
  public String decrypt(String message, String digitalEnvelope) throws Exception {
      digitalEnvelope = new String(EncryptUtil.decrypt(mechanism, this.privateKey, digitalEnvelope.getBytes(), session), StandardCharsets.UTF_8);
    String[] strs = digitalEnvelope.split("\\|");
    return DgEnvUtils.generatePlainText(strs, message);
  }

  @Override
  public String getSN() {
    return String.valueOf(this.x509Cert.getStringSerialNumber());
  }

  @Override
  public String decrypt(String message) throws Exception {
    return new String(EncryptUtil.decrypt(mechanism, this.privateKey, message.getBytes(), session), StandardCharsets.UTF_8);
  }

  @Override
  public String getSymmetricCipher() {
    return PayUtils.randomHexString(16);
  }

  @Override
  public String getAlgorithm() {
    return this.x509Cert.getSignatureAlgName();
  }

}
