package com.biz.crm.cpcnpay.core.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 中金对账单中交易状态
 *
 * @author hecheng
 */
@Getter
@AllArgsConstructor
public enum CpcnBillTransactionStatus {
  /**
   * 处理中
   */
  processing("20", "处理中"),
  /**
   * 成功
   */
  SUCCESS("30", "成功"),
  /**
   * 失败
   */
  FAIL("40", "失败"),
  ;

  /**
   * code
   */
  private final String code;

  /**
   * 描述
   */
  private final String desc;

  public static CpcnBillTransactionStatus getByCode(String code) {
    for (CpcnBillTransactionStatus type : CpcnBillTransactionStatus.values()) {
      if (type.getCode().equals(code)) {
        return type;
      }
    }
    return null;
  }
}
