package com.biz.crm.cpcnpay.core.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 中金对账单下载状态
 *
 * @author hecheng
 */
@Getter
@AllArgsConstructor
public enum CpcnDownloadFileStatus {
  /**
   * 下载成功
   */
  SUCCESS("10", "下载成功"),
  /**
   * 下载失败
   */
  FAIL("20", "下载失败"),

  ;

  /**
   * code
   */
  private final String code;

  /**
   * 描述
   */
  private final String desc;

  public static CpcnDownloadFileStatus getByCode(String code) {
    CpcnDownloadFileStatus[] types= CpcnDownloadFileStatus.values();
    for (CpcnDownloadFileStatus type:types) {
      if(Objects.equals(type.getCode(),code)){
        return type;
      }
    }
    throw new IllegalArgumentException(String.format("不存在code=%s的CpcnDownloadFileStatus",code));
  }
}
