package com.biz.crm.cpcnpay.core.configuration;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 中金支付配置信息
 *
 * @author Keller
 */
@ConfigurationProperties(prefix = CpcnProperties.PREFIX)
@Getter
@Setter
@ToString
public class CpcnProperties {

  public final static String PREFIX = "pay.cpcn";
  /**
   * 平台名称
   */
  private String platformName;
  /**
   * 加密算法
   */
  private String algorithm;
  /**
   * 支付平台支付接口地址
   */
  private String paymentUrl;
  /**
   * 支付平台交易接口地址
   */
  private String txUrl;
  /**
   * 统一下单接口地址
   */
  private String gateway4aggregatePaymentUrl;
  /**
   * 支付平台交易接口地址
   */
  private String gateway4aggregateTxUrl;
  /**
   * Gateway4File
   */
  private String gateway4fileUrl;
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 名称
   */
  private String name;
  /**
   * 商户编号
   */
  private String merchant;
  /**
   * 平台私钥证书密码
   */
  private String password;
  /**
   * 加密类型 10:国际加密 20:国密加密
   */
  private String encryptType;
  /**
   * 平台公钥（支持 classpath: 与 file: 方式）
   */
  private String pubKey;
  /**
   * 平台私钥（支持 classpath: 与 file: 方式）
   */
  private String priKey;
  /**
   * 忽略hostname开关
   */
  private boolean ignoreHostName;
  /**
   * 回调通知地址
   */
  private String noticeUrl;
  /**
   * trust 文件路径
   */
  private String trustKey;
  /**
   * trust 文件密码
   */
  private String trustPassword;
  /**
   * 调试开关 打开次开会针对中金的测试环境（将会采用测试环境特定的测试数据）
   */
  private boolean debug = false;
  /**
   * 远程通知地址
   */
  private String[] remoteUrl;
  /**
   * 是否使用代理
   * TODO 待后续空闲了实现
   */
  private boolean useHttpProxy;
  /**
   * 代理信息
   * TODO 待后续空闲了实现
   */
  private Proxy proxy;

}

@Getter
@Setter
class Proxy{
  /**
   * 代理地址
   */
  private String hostname;
  /**
   * 代理端口
   */
  private String port;
  /**
   * 代理服务器用户名
   */
  private String userName;
  /**
   * 代理服务器密码
   */
  private String password;
}