package com.biz.crm.cpcnpay.core.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cpcnpay.core.service.NoticeService;
import com.biz.crm.cpcnpay.core.vo.NoticeInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * 回调接口
 *
 * @author Keller
 */
@Slf4j
@RestController
@RequestMapping(path = "/v1/pay/notice")
@Api(tags = "中金额支付回调")
public class NoticeController {
  /**
   * 固定的返回值（中金的强烈要求）
   */
  public static final String RETURN_MESSAGE = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48UmVzcG9uc2UgdmVyc2lvbj0iMi4wIj48SGVhZD48Q29kZT4yMDAwPC9Db2RlPjxNZXNzYWdlPk9LLjwvTWVzc2FnZT48L0hlYWQ+PC9SZXNwb25zZT4=";

  @Autowired
  private NoticeService noticeService;

  /**
   * 统一处理中金回调
   *
   * @param request
   * @return
   */
  @ApiOperation(value = "回调请求")
  @RequestMapping(value = "", method = RequestMethod.POST)
  public String notice(HttpServletRequest request) {
    try {
      log.info("收到中金回调请求>>>>>>>>>>>>>>>>");
      NoticeInfo data = new NoticeInfo();
      data.setMessage(request.getParameter("message"));
      data.setSignature(request.getParameter("signature"));
      log.error("中金回调请求参数:{}", JSON.toJSONString(data));
      noticeService.handlerNotice(data);
    } catch (Exception e) {
      log.error("处理中金回调出现错误", e);
      return null;
    }
    return RETURN_MESSAGE;
  }


  /**
   * 统一处理中金回调
   * 此接口和上面的接口功能一样,只是接收参数不一样，一个是直接从request里面获取，另一个是从请求体中获取,用于测试
   * 由于参数是base64加密,其中会有'+'号等特殊符号,如果是在request里面取值工具会把值拼接到URL后面,这样导致特殊符号如加号丢失,导致解密失败,所以如果是测试回调使用此接口
   */
  @ApiOperation(value = "回调请求")
  @PostMapping(value = "/noticeTest")
  public String noticeTest(@RequestBody NoticeInfo data) {
    try {
      log.info("收到中金回调请求>>>>>>>>>>>>>>>>");
      log.error("中金回调请求参数:{}", JSON.toJSONString(data));
      noticeService.handlerNotice(data);
    } catch (Exception e) {
      log.error("处理中金回调出现错误", e);
      return null;
    }
    return RETURN_MESSAGE;
  }
}
