package com.biz.crm.cpcnpay.core.notice;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 4668-白名单开通/注销通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice4668Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 原业务流水号
   */
  private String sourceTxSN;
  /**
   * 白名单状态: 20=启用 30=失效
   */
  private String status;
  /**
   * 响应时间
   * <p>
   * 格式:yyyyMMddHHmmssSSS
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Notice4668Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.sourceTxSN = XmlUtils.getNodeText(document, "SourceTxSN");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
  }

}
