package com.biz.crm.cpcnpay.core.notice;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 7709-壹企付用户签约成功后台通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice7709Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 申请流水号
   */
  private String applyNo;
  /**
   * 状态:
   * 20=签约成功
   */
  private String status;
  /**
   * 通过时间 20110712080808888
   */
  private String signTime;

  public Notice7709Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.applyNo = XmlUtils.getNodeText(document, "ApplyNo");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.signTime = XmlUtils.getNodeText(document, "SignTime");
  }
}
