package com.biz.crm.cpcnpay.core.strategy.tx;

import com.biz.crm.cpcnpay.core.strategy.tx.internal.NilTxStrategy;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 中金支付策略管理器
 * 该管理器缓存所有需要执行的策略信息，在springbean初始化时候进行加载
 *
 * @author Keller
 */
@Component
@AllArgsConstructor
public class TxManager {
  /**
   * 策略容器
   */
  private List<AbstractTxStrategy> STRATEGYS;

  /**
   * 空策略执行器
   */
  private NilTxStrategy nilTxStrategy;

  /**
   * 根据接口编号获取对应的处理策略
   *
   * @param code
   * @return
   */
  public AbstractTxStrategy getHandler(String code) {
    Optional<AbstractTxStrategy> optional = STRATEGYS.stream().filter(item -> Objects.equals(item.getCode(), code)).findFirst();
    return optional.orElse(nilTxStrategy);
  }

}
