package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.payroll.Tx4600Request;
import com.biz.crm.cpcnpay.core.tx.payroll.Tx4600Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4600-影印件采集
 *
 * <pre>
 *    4600-影印件采集接口用于用户在机构系统开立中金支付账户前的影印件信息采集。
 *    用户在机构系统上传相关文件并提交，机构系统通过该接口将用户提交的影印件信息发送到支付平台，
 *    支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 *    目前中金存管的个体户和企业开户方式、银行存管的亿联银行存管模式的个体户和企业开户方式、
 *    银行存管的众邦银行存管模式的企业开户是必须上传影印件的。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4600Strategy extends AbstractTxStrategy<Tx4600Request, Tx4600Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4600_REQUEST.getCode();
  }

  @Override
  public Class<Tx4600Response> getResponse() {
    return Tx4600Response.class;
  }
}
