package com.biz.crm.cpcnpay.core.strategy.tx.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnRequestType;
import com.biz.crm.cpcnpay.core.strategy.tx.AbstractTxStrategy;
import com.biz.crm.cpcnpay.core.tx.aggregate.Tx5014Request;
import com.biz.crm.cpcnpay.core.tx.aggregate.Tx5014Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 5014-订单关闭
 *
 * <pre>
 *     5014 是订单关闭接口，机构系统向支付平台发起订单关闭指令，
 *     支付平台 立即进行关单处理，并将处理结果实时返回给机构系统。
 *     关单成功后，用户将不能对该笔订单进行支付。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx5014Strategy extends AbstractTxStrategy<Tx5014Request, Tx5014Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5014_REQUEST.getCode();
  }

  @Override
  public Class<Tx5014Response> getResponse() {
    return Tx5014Response.class;
  }
}
