package com.biz.crm.cpcnpay.core.tx.enrollment;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 7703-壹企付用户签约入网 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx7703Response extends TxBaseResponse {
  private String institutionID;

  private String applyNo;

  private String status;

  private String phoneNumber;

  public Tx7703Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.applyNo = XmlUtils.getNodeText(document, "ApplyNo");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.phoneNumber = XmlUtils.getNodeText(document, "PhoneNumber");
    }
  }
}
