package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4656-充值/提现/代付查询 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4656Response extends TxBaseResponse {
  /**
   * 交易流水号
   */
  private String txSN;
  /**
   * 金额
   */
  private String amount;
  /**
   * 交易状态
   * <p>
   * 20=处理中
   * 40=失败
   */
  private String status;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 绑卡流水号
   */
  private String bindingTxSN;
  /**
   * 提现方式;
   *
   * 0-接口提现
   * 1-商户服务系统提现
   * 2-自动提现
   */
  private String withdrawalType;
  /**
   * 备注
   */
  private String remark;
  /**
   * 实际支付卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 40=未知
   */
  private String cardType;

  public Tx4656Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.amount = XmlUtils.getNodeText(document, "Amount");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
      this.bindingTxSN = XmlUtils.getNodeText(document, "BindingTxSN");
      this.withdrawalType = XmlUtils.getNodeText(document, "WithdrawalType");
      this.remark = XmlUtils.getNodeText(document, "Remark");
      this.cardType = XmlUtils.getNodeText(document, "CardType");
    }
  }

}
