package com.biz.crm.cpcnpay.core.tx.foundationaccount;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4691-用户信息查询
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4691Request extends TxBaseRequest {

  private String userID;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element UserID = document.createElement("UserID");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    postProcess(document);
  }
}
