package com.biz.crm.cpcnpay.core.tx.gatheringaccredit;

import com.biz.crm.cpcnpay.core.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 2751-卡 bin 信息查询
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx2751Request extends TxBaseRequest {
  /**
   * 交易流水
   */
  @NotBlank(message = "交易流水不能为空")
  private String txSN;
  /**
   * 账号
   */
  @NotBlank(message = "账号不能为空")
  private String accountNumber;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element AccountNumber = document.createElement("AccountNumber");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    Body.appendChild(TxSN);
    Body.appendChild(AccountNumber);
    TxCode.setTextContent(this.txCode);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    TxSN.setTextContent(this.txSN);
    AccountNumber.setTextContent(this.accountNumber);
    postProcess(document);
  }
}
