package com.biz.crm.cpcnpay.core.tx.payroll;

import com.biz.crm.cpcnpay.common.utils.XmlUtils;
import com.biz.crm.cpcnpay.core.common.constant.Constants;
import com.biz.crm.cpcnpay.core.config.CpcnConfig;
import com.biz.crm.cpcnpay.core.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4600-影印件采集 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4600Response extends TxBaseResponse {
  /**
   * 交易流水号，同请求
   */
  private String txSN;
  /**
   * 交易状态: 20=采集成功 30=采集失败
   */
  private String status;
  /**
   * 响应代码，Status=30 时必填
   */
  private String responseCode;
  /**
   * 响应消息，Status=30 时必填
   */
  private String responseMessage;

  public Tx4600Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
