/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice2736Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice2736Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice2736Strategy
implements NoticeStrategy<Notice2736Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice2736Strategy.class);
    @Autowired(required=false)
    private List<Notice2736Listener> notice2736Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_2736.getCode();
    }

    @Override
    public Notice2736Request exchange(NoticeRequest request) throws Exception {
        return new Notice2736Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice2736Request notice2736Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice2736Listeners)) {
                for (Notice2736Listener listener : this.notice2736Listeners) {
                    listener.onNotice(notice2736Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u58f9\u4f01\u4ed8\u7528\u6237\u7b7e\u7ea6\u6210\u529f\u540e\u53f0\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

