/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice5018Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice5018Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class Notice5018Strategy
implements NoticeStrategy<Notice5018Request> {
    private static final Logger log = LoggerFactory.getLogger(Notice5018Strategy.class);
    @Autowired(required=false)
    private List<Notice5018Listener> notice5018Listeners;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_5018.getCode();
    }

    @Override
    public Notice5018Request exchange(NoticeRequest request) throws Exception {
        return new Notice5018Request(request.getDocument());
    }

    @Override
    public void handler(NoticeRequest request) {
        try {
            Notice5018Request notice5018Request = this.exchange(request);
            if (!CollectionUtils.isEmpty(this.notice5018Listeners)) {
                for (Notice5018Listener listener : this.notice5018Listeners) {
                    listener.onNotice(notice5018Request);
                }
            }
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u901a\u77e5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

