package com.biz.crm.cpcnpay.core.strategy.notice.internal;

import com.biz.crm.cpcnpay.core.common.enums.CpcnNoticeType;
import com.biz.crm.cpcnpay.core.notice.Notice5088Request;
import com.biz.crm.cpcnpay.core.notice.NoticeRequest;
import com.biz.crm.cpcnpay.core.service.notifier.Notice5088Listener;
import com.biz.crm.cpcnpay.core.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 5018-冻结订单分账撤销通知
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice5088Strategy implements NoticeStrategy<Notice5088Request> {
  @Autowired(required = false)
  private List<Notice5088Listener> notice5088Listeners;
  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_5088.getCode();
  }

  @Override
  public Notice5088Request exchange(NoticeRequest request) throws Exception {
    return new Notice5088Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice5088Request notice5088Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice5088Listeners)) {
        for (Notice5088Listener listener : notice5088Listeners) {
          listener.onNotice(notice5088Request);
        }
      }
    } catch (Exception e) {
      log.error("冻结订单分账撤销通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
